/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.keymanager;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;

public final class CompositeX509ExtendedKeyManager
extends X509ExtendedKeyManager {
    private final List<X509ExtendedKeyManager> keyManagers;
    private final Map<String, List<URI>> preferredClientAliasToHost;

    public CompositeX509ExtendedKeyManager(List<? extends X509ExtendedKeyManager> keyManagers) {
        this(keyManagers, Collections.emptyMap());
    }

    public CompositeX509ExtendedKeyManager(List<? extends X509ExtendedKeyManager> keyManagers, Map<String, List<URI>> preferredClientAliasToHost) {
        this.keyManagers = Collections.unmodifiableList(keyManagers);
        this.preferredClientAliasToHost = new HashMap<String, List<URI>>(preferredClientAliasToHost);
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        Optional<Object> preferredAlias = Optional.empty();
        if (!this.preferredClientAliasToHost.isEmpty() && socket != null && socket.getRemoteSocketAddress() instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)socket.getRemoteSocketAddress();
            preferredAlias = this.getPreferredClientAlias(address.getHostName(), address.getPort());
        }
        for (X509ExtendedKeyManager keyManager : this.keyManagers) {
            String alias = keyManager.chooseClientAlias(keyType, issuers, socket);
            if (alias == null) continue;
            if (preferredAlias.isPresent()) {
                if (!((String)preferredAlias.get()).equals(alias)) continue;
                return alias;
            }
            return alias;
        }
        return null;
    }

    @Override
    public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine sslEngine) {
        Optional<Object> preferredAlias = Optional.empty();
        if (!this.preferredClientAliasToHost.isEmpty() && sslEngine != null) {
            preferredAlias = this.getPreferredClientAlias(sslEngine.getPeerHost(), sslEngine.getPeerPort());
        }
        for (X509ExtendedKeyManager keyManager : this.keyManagers) {
            String alias = keyManager.chooseEngineClientAlias(keyTypes, issuers, sslEngine);
            if (alias == null) continue;
            if (preferredAlias.isPresent()) {
                if (!((String)preferredAlias.get()).equals(alias)) continue;
                return alias;
            }
            return alias;
        }
        return null;
    }

    private Optional<String> getPreferredClientAlias(String peerHost, int peerPort) {
        return this.preferredClientAliasToHost.entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().anyMatch(uri -> uri.getHost().equals(peerHost))).filter(entry -> ((List)entry.getValue()).stream().anyMatch(uri -> uri.getPort() == peerPort)).findFirst().map(Map.Entry::getKey);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        for (X509ExtendedKeyManager keyManager : this.keyManagers) {
            String alias = keyManager.chooseServerAlias(keyType, issuers, socket);
            if (alias == null) continue;
            return alias;
        }
        return null;
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine sslEngine) {
        for (X509ExtendedKeyManager keyManager : this.keyManagers) {
            String alias = keyManager.chooseEngineServerAlias(keyType, issuers, sslEngine);
            if (alias == null) continue;
            return alias;
        }
        return null;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        for (X509ExtendedKeyManager keyManager : this.keyManagers) {
            PrivateKey privateKey = keyManager.getPrivateKey(alias);
            if (privateKey == null) continue;
            return privateKey;
        }
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        for (X509ExtendedKeyManager keyManager : this.keyManagers) {
            X509Certificate[] chain = keyManager.getCertificateChain(alias);
            if (chain == null || chain.length <= 0) continue;
            return chain;
        }
        return null;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        ArrayList clientAliases = new ArrayList();
        for (X509ExtendedKeyManager keyManager : this.keyManagers) {
            Optional.ofNullable(keyManager.getClientAliases(keyType, issuers)).ifPresent(aliases -> clientAliases.addAll(Arrays.asList(aliases)));
        }
        return this.emptyToNull(clientAliases.toArray(new String[0]));
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        ArrayList serverAliases = new ArrayList();
        for (X509ExtendedKeyManager keyManager : this.keyManagers) {
            Optional.ofNullable(keyManager.getServerAliases(keyType, issuers)).ifPresent(aliases -> serverAliases.addAll(Arrays.asList(aliases)));
        }
        return this.emptyToNull(serverAliases.toArray(new String[0]));
    }

    private <T> T[] emptyToNull(T[] arr) {
        return arr.length == 0 ? null : arr;
    }

    public int size() {
        return this.keyManagers.size();
    }

    public List<X509ExtendedKeyManager> getKeyManagers() {
        return this.keyManagers;
    }

    public Map<String, List<URI>> getPreferredClientAliasToHosts() {
        return this.preferredClientAliasToHost;
    }
}

