/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.trustmanager;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompositeX509ExtendedTrustManager
extends X509ExtendedTrustManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeX509ExtendedTrustManager.class);
    private static final String CERTIFICATE_EXCEPTION_MESSAGE = "None of the TrustManagers trust this certificate chain";
    private static final String CLIENT_CERTIFICATE_LOG_MESSAGE = "Received the following client certificate: [{}]";
    private static final String SERVER_CERTIFICATE_LOG_MESSAGE = "Received the following server certificate: [{}]";
    private final List<? extends X509ExtendedTrustManager> trustManagers;
    private final X509Certificate[] acceptedIssuers;

    public CompositeX509ExtendedTrustManager(List<? extends X509ExtendedTrustManager> trustManagers) {
        this.trustManagers = Collections.unmodifiableList(trustManagers);
        this.acceptedIssuers = (X509Certificate[])trustManagers.stream().map(X509TrustManager::getAcceptedIssuers).flatMap(Arrays::stream).distinct().toArray(X509Certificate[]::new);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(CLIENT_CERTIFICATE_LOG_MESSAGE, (Object)chain[0].getSubjectDN());
        }
        ArrayList<CertificateException> certificateExceptions = new ArrayList<CertificateException>();
        for (X509ExtendedTrustManager x509ExtendedTrustManager : this.trustManagers) {
            try {
                x509ExtendedTrustManager.checkClientTrusted(chain, authType);
                return;
            }
            catch (CertificateException e) {
                certificateExceptions.add(e);
            }
        }
        CertificateException certificateException = new CertificateException(CERTIFICATE_EXCEPTION_MESSAGE);
        certificateExceptions.forEach(certificateException::addSuppressed);
        throw certificateException;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(CLIENT_CERTIFICATE_LOG_MESSAGE, (Object)chain[0].getSubjectDN());
        }
        ArrayList<CertificateException> certificateExceptions = new ArrayList<CertificateException>();
        for (X509ExtendedTrustManager x509ExtendedTrustManager : this.trustManagers) {
            try {
                x509ExtendedTrustManager.checkClientTrusted(chain, authType, socket);
                return;
            }
            catch (CertificateException e) {
                certificateExceptions.add(e);
            }
        }
        CertificateException certificateException = new CertificateException(CERTIFICATE_EXCEPTION_MESSAGE);
        certificateExceptions.forEach(certificateException::addSuppressed);
        throw certificateException;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(CLIENT_CERTIFICATE_LOG_MESSAGE, (Object)chain[0].getSubjectDN());
        }
        ArrayList<CertificateException> certificateExceptions = new ArrayList<CertificateException>();
        for (X509ExtendedTrustManager x509ExtendedTrustManager : this.trustManagers) {
            try {
                x509ExtendedTrustManager.checkClientTrusted(chain, authType, sslEngine);
                return;
            }
            catch (CertificateException e) {
                certificateExceptions.add(e);
            }
        }
        CertificateException certificateException = new CertificateException(CERTIFICATE_EXCEPTION_MESSAGE);
        certificateExceptions.forEach(certificateException::addSuppressed);
        throw certificateException;
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(SERVER_CERTIFICATE_LOG_MESSAGE, (Object)chain[0].getSubjectDN());
        }
        ArrayList<CertificateException> certificateExceptions = new ArrayList<CertificateException>();
        for (X509ExtendedTrustManager x509ExtendedTrustManager : this.trustManagers) {
            try {
                x509ExtendedTrustManager.checkServerTrusted(chain, authType);
                return;
            }
            catch (CertificateException e) {
                certificateExceptions.add(e);
            }
        }
        CertificateException certificateException = new CertificateException(CERTIFICATE_EXCEPTION_MESSAGE);
        certificateExceptions.forEach(certificateException::addSuppressed);
        throw certificateException;
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(SERVER_CERTIFICATE_LOG_MESSAGE, (Object)chain[0].getSubjectDN());
        }
        ArrayList<CertificateException> certificateExceptions = new ArrayList<CertificateException>();
        for (X509ExtendedTrustManager x509ExtendedTrustManager : this.trustManagers) {
            try {
                x509ExtendedTrustManager.checkServerTrusted(chain, authType, socket);
                return;
            }
            catch (CertificateException e) {
                certificateExceptions.add(e);
            }
        }
        CertificateException certificateException = new CertificateException(CERTIFICATE_EXCEPTION_MESSAGE);
        certificateExceptions.forEach(certificateException::addSuppressed);
        throw certificateException;
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(SERVER_CERTIFICATE_LOG_MESSAGE, (Object)chain[0].getSubjectDN());
        }
        ArrayList<CertificateException> certificateExceptions = new ArrayList<CertificateException>();
        for (X509ExtendedTrustManager x509ExtendedTrustManager : this.trustManagers) {
            try {
                x509ExtendedTrustManager.checkServerTrusted(chain, authType, sslEngine);
                return;
            }
            catch (CertificateException e) {
                certificateExceptions.add(e);
            }
        }
        CertificateException certificateException = new CertificateException(CERTIFICATE_EXCEPTION_MESSAGE);
        certificateExceptions.forEach(certificateException::addSuppressed);
        throw certificateException;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return Arrays.copyOf(this.acceptedIssuers, this.acceptedIssuers.length);
    }

    protected int size() {
        return this.trustManagers.size();
    }
}

