/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.model;

import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import nl.altindag.ssl.model.IdentityMaterial;
import nl.altindag.ssl.model.TrustMaterial;

public final class SSLMaterial {
    private SSLContext sslContext;
    private SSLSocketFactory sslSocketFactory;
    private SSLServerSocketFactory sslServerSocketFactory;
    private IdentityMaterial identityMaterial;
    private TrustMaterial trustMaterial;
    private HostnameVerifier hostnameVerifier;
    private SSLParameters sslParameters;
    private List<String> ciphers;
    private List<String> protocols;

    private SSLMaterial() {
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public IdentityMaterial getIdentityMaterial() {
        return this.identityMaterial;
    }

    public TrustMaterial getTrustMaterial() {
        return this.trustMaterial;
    }

    public SSLServerSocketFactory getSslServerSocketFactory() {
        return this.sslServerSocketFactory;
    }

    public SSLParameters getSslParameters() {
        return this.sslParameters;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public List<String> getCiphers() {
        return this.ciphers;
    }

    public List<String> getProtocols() {
        return this.protocols;
    }

    public static class Builder {
        private SSLContext sslContext;
        private SSLSocketFactory sslSocketFactory;
        private SSLServerSocketFactory sslServerSocketFactory;
        private IdentityMaterial identityMaterial;
        private TrustMaterial trustMaterial;
        private HostnameVerifier hostnameVerifier;
        private SSLParameters sslParameters;
        private List<String> ciphers;
        private List<String> protocols;

        public Builder withSslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder withSslSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
            return this;
        }

        public Builder withSslServerSocketFactory(SSLServerSocketFactory sslServerSocketFactory) {
            this.sslServerSocketFactory = sslServerSocketFactory;
            return this;
        }

        public Builder withHostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder withSslParameters(SSLParameters sslParameters) {
            this.sslParameters = sslParameters;
            return this;
        }

        public Builder withCiphers(List<String> ciphers) {
            this.ciphers = ciphers;
            return this;
        }

        public Builder withProtocols(List<String> protocols) {
            this.protocols = protocols;
            return this;
        }

        public Builder withIdentityMaterial(IdentityMaterial identityMaterial) {
            this.identityMaterial = identityMaterial;
            return this;
        }

        public Builder withTrustMaterial(TrustMaterial trustMaterial) {
            this.trustMaterial = trustMaterial;
            return this;
        }

        public SSLMaterial build() {
            SSLMaterial sslMaterial = new SSLMaterial();
            sslMaterial.sslContext = this.sslContext;
            sslMaterial.sslSocketFactory = this.sslSocketFactory;
            sslMaterial.sslServerSocketFactory = this.sslServerSocketFactory;
            sslMaterial.identityMaterial = this.identityMaterial;
            sslMaterial.trustMaterial = this.trustMaterial;
            sslMaterial.hostnameVerifier = this.hostnameVerifier;
            sslMaterial.sslParameters = this.sslParameters;
            sslMaterial.ciphers = this.ciphers;
            sslMaterial.protocols = this.protocols;
            return sslMaterial;
        }
    }
}

