/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl;

import java.io.InputStream;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import nl.altindag.ssl.exception.GenericKeyStoreException;
import nl.altindag.ssl.exception.GenericSecurityException;
import nl.altindag.ssl.model.IdentityMaterial;
import nl.altindag.ssl.model.KeyStoreHolder;
import nl.altindag.ssl.model.SSLMaterial;
import nl.altindag.ssl.model.TrustMaterial;
import nl.altindag.ssl.util.KeyManagerUtils;
import nl.altindag.ssl.util.KeyStoreUtils;
import nl.altindag.ssl.util.SSLContextUtils;
import nl.altindag.ssl.util.SocketUtils;
import nl.altindag.ssl.util.TrustManagerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SSLFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSLFactory.class);
    private final SSLMaterial sslMaterial;

    private SSLFactory(SSLMaterial sslMaterial) {
        this.sslMaterial = sslMaterial;
    }

    public List<KeyStoreHolder> getIdentities() {
        return this.sslMaterial.getIdentityMaterial().getIdentities();
    }

    public List<KeyStoreHolder> getTrustStores() {
        return this.sslMaterial.getTrustMaterial().getTrustStores();
    }

    public SSLContext getSslContext() {
        return this.sslMaterial.getSslContext();
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslMaterial.getSslSocketFactory();
    }

    public SSLServerSocketFactory getSslServerSocketFactory() {
        return this.sslMaterial.getSslServerSocketFactory();
    }

    public Optional<X509ExtendedKeyManager> getKeyManager() {
        return Optional.ofNullable(this.sslMaterial.getIdentityMaterial().getKeyManager());
    }

    public Optional<KeyManagerFactory> getKeyManagerFactory() {
        return Optional.ofNullable(this.sslMaterial.getIdentityMaterial().getKeyManagerFactory());
    }

    public Optional<X509ExtendedTrustManager> getTrustManager() {
        return Optional.ofNullable(this.sslMaterial.getTrustMaterial().getTrustManager());
    }

    public Optional<TrustManagerFactory> getTrustManagerFactory() {
        return Optional.ofNullable(this.sslMaterial.getTrustMaterial().getTrustManagerFactory());
    }

    public List<X509Certificate> getTrustedCertificates() {
        return this.sslMaterial.getTrustMaterial().getTrustedCertificates();
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.sslMaterial.getHostnameVerifier();
    }

    public List<String> getCiphers() {
        return this.sslMaterial.getCiphers();
    }

    public List<String> getProtocols() {
        return this.sslMaterial.getProtocols();
    }

    public SSLParameters getSslParameters() {
        return this.sslMaterial.getSslParameters();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final String TRUST_STORE_VALIDATION_EXCEPTION_MESSAGE = "TrustStore details are empty, which are required to be present when SSL/TLS is enabled";
        private static final String IDENTITY_VALIDATION_EXCEPTION_MESSAGE = "Identity details are empty, which are required to be present when SSL/TLS is enabled";
        private static final String IDENTITY_AND_TRUST_MATERIAL_VALIDATION_EXCEPTION_MESSAGE = "Could not create instance of SSLFactory because Identity and Trust material are not present. Please provide at least a Trust material.";
        private static final char[] EMPTY_PASSWORD = new char[0];
        private String sslContextProtocol = "TLS";
        private Provider securityProvider = null;
        private String securityProviderName = null;
        private SecureRandom secureRandom = null;
        private HostnameVerifier hostnameVerifier = (host, sslSession) -> host.equalsIgnoreCase(sslSession.getPeerHost());
        private final List<KeyStoreHolder> identities = new ArrayList<KeyStoreHolder>();
        private final List<KeyStoreHolder> trustStores = new ArrayList<KeyStoreHolder>();
        private final List<X509ExtendedKeyManager> identityManagers = new ArrayList<X509ExtendedKeyManager>();
        private final List<X509ExtendedTrustManager> trustManagers = new ArrayList<X509ExtendedTrustManager>();
        private final SSLParameters sslParameters = new SSLParameters();
        private boolean passwordCachingEnabled = false;

        private Builder() {
        }

        public Builder withSystemTrustMaterial() {
            TrustManagerUtils.createTrustManagerWithSystemTrustedCertificates().ifPresent(this.trustManagers::add);
            return this;
        }

        public Builder withDefaultTrustMaterial() {
            this.trustManagers.add(TrustManagerUtils.createTrustManagerWithJdkTrustedCertificates());
            return this;
        }

        public <T extends X509TrustManager> Builder withTrustMaterial(T trustManager) {
            this.trustManagers.add(TrustManagerUtils.wrapIfNeeded(trustManager));
            return this;
        }

        public <T extends TrustManagerFactory> Builder withTrustMaterial(T trustManagerFactory) {
            X509ExtendedTrustManager trustManager = TrustManagerUtils.getTrustManager(trustManagerFactory);
            this.trustManagers.add(trustManager);
            return this;
        }

        public Builder withTrustMaterial(String trustStorePath, char[] trustStorePassword) {
            return this.withTrustMaterial(trustStorePath, trustStorePassword, KeyStore.getDefaultType());
        }

        public Builder withTrustMaterial(String trustStorePath, char[] trustStorePassword, String trustStoreType) {
            if (this.isBlank(trustStorePath)) {
                throw new GenericKeyStoreException(TRUST_STORE_VALIDATION_EXCEPTION_MESSAGE);
            }
            KeyStore trustStore = KeyStoreUtils.loadKeyStore(trustStorePath, trustStorePassword, trustStoreType);
            KeyStoreHolder trustStoreHolder = new KeyStoreHolder(trustStore, trustStorePassword);
            this.trustStores.add(trustStoreHolder);
            return this;
        }

        public Builder withTrustMaterial(Path trustStorePath, char[] trustStorePassword) {
            return this.withTrustMaterial(trustStorePath, trustStorePassword, KeyStore.getDefaultType());
        }

        public Builder withTrustMaterial(Path trustStorePath, char[] trustStorePassword, String trustStoreType) {
            if (Objects.isNull(trustStorePath) || this.isBlank(trustStoreType)) {
                throw new GenericKeyStoreException(TRUST_STORE_VALIDATION_EXCEPTION_MESSAGE);
            }
            KeyStore trustStore = KeyStoreUtils.loadKeyStore(trustStorePath, trustStorePassword, trustStoreType);
            KeyStoreHolder trustStoreHolder = new KeyStoreHolder(trustStore, trustStorePassword);
            this.trustStores.add(trustStoreHolder);
            return this;
        }

        public Builder withTrustMaterial(InputStream trustStoreStream, char[] trustStorePassword) {
            return this.withTrustMaterial(trustStoreStream, trustStorePassword, KeyStore.getDefaultType());
        }

        public Builder withTrustMaterial(InputStream trustStoreStream, char[] trustStorePassword, String trustStoreType) {
            KeyStore trustStore = KeyStoreUtils.loadKeyStore(trustStoreStream, trustStorePassword, trustStoreType);
            KeyStoreHolder trustStoreHolder = new KeyStoreHolder(trustStore, trustStorePassword);
            this.trustStores.add(trustStoreHolder);
            return this;
        }

        public Builder withTrustMaterial(KeyStore trustStore) {
            this.withTrustMaterial(trustStore, EMPTY_PASSWORD);
            return this;
        }

        public Builder withTrustMaterial(KeyStore trustStore, char[] trustStorePassword) {
            this.validateKeyStore(trustStore, TRUST_STORE_VALIDATION_EXCEPTION_MESSAGE);
            KeyStoreHolder trustStoreHolder = new KeyStoreHolder(trustStore, trustStorePassword);
            this.trustStores.add(trustStoreHolder);
            return this;
        }

        @SafeVarargs
        public final <T extends Certificate> Builder withTrustMaterial(T ... certificates) {
            return this.withTrustMaterial(Arrays.asList(certificates));
        }

        public <T extends Certificate> Builder withTrustMaterial(List<T> certificates) {
            KeyStore trustStore = KeyStoreUtils.createTrustStore(certificates);
            KeyStoreHolder trustStoreHolder = new KeyStoreHolder(trustStore, "dummy-password".toCharArray());
            this.trustStores.add(trustStoreHolder);
            return this;
        }

        public Builder withIdentityMaterial(String identityStorePath, char[] identityStorePassword) {
            return this.withIdentityMaterial(identityStorePath, identityStorePassword, identityStorePassword, KeyStore.getDefaultType());
        }

        public Builder withIdentityMaterial(String identityStorePath, char[] identityStorePassword, char[] identityPassword) {
            return this.withIdentityMaterial(identityStorePath, identityStorePassword, identityPassword, KeyStore.getDefaultType());
        }

        public Builder withIdentityMaterial(String identityStorePath, char[] identityStorePassword, String identityStoreType) {
            return this.withIdentityMaterial(identityStorePath, identityStorePassword, identityStorePassword, identityStoreType);
        }

        public Builder withIdentityMaterial(String identityStorePath, char[] identityStorePassword, char[] identityPassword, String identityStoreType) {
            if (this.isBlank(identityStorePath) || this.isBlank(identityStoreType)) {
                throw new GenericKeyStoreException(IDENTITY_VALIDATION_EXCEPTION_MESSAGE);
            }
            KeyStore identity = KeyStoreUtils.loadKeyStore(identityStorePath, identityStorePassword, identityStoreType);
            KeyStoreHolder identityHolder = new KeyStoreHolder(identity, identityStorePassword, identityPassword);
            this.identities.add(identityHolder);
            return this;
        }

        public Builder withIdentityMaterial(Path identityStorePath, char[] identityStorePassword) {
            return this.withIdentityMaterial(identityStorePath, identityStorePassword, identityStorePassword, KeyStore.getDefaultType());
        }

        public Builder withIdentityMaterial(Path identityStorePath, char[] identityStorePassword, char[] identityPassword) {
            return this.withIdentityMaterial(identityStorePath, identityStorePassword, identityPassword, KeyStore.getDefaultType());
        }

        public Builder withIdentityMaterial(Path identityStorePath, char[] identityStorePassword, String identityStoreType) {
            return this.withIdentityMaterial(identityStorePath, identityStorePassword, identityStorePassword, identityStoreType);
        }

        public Builder withIdentityMaterial(Path identityStorePath, char[] identityStorePassword, char[] identityPassword, String identityStoreType) {
            if (Objects.isNull(identityStorePath) || this.isBlank(identityStoreType)) {
                throw new GenericKeyStoreException(IDENTITY_VALIDATION_EXCEPTION_MESSAGE);
            }
            KeyStore identity = KeyStoreUtils.loadKeyStore(identityStorePath, identityStorePassword, identityStoreType);
            KeyStoreHolder identityHolder = new KeyStoreHolder(identity, identityStorePassword, identityPassword);
            this.identities.add(identityHolder);
            return this;
        }

        public Builder withIdentityMaterial(InputStream identityStorePath, char[] identityStorePassword) {
            return this.withIdentityMaterial(identityStorePath, identityStorePassword, identityStorePassword);
        }

        public Builder withIdentityMaterial(InputStream identityStorePath, char[] identityStorePassword, char[] identityPassword) {
            return this.withIdentityMaterial(identityStorePath, identityStorePassword, identityPassword, KeyStore.getDefaultType());
        }

        public Builder withIdentityMaterial(InputStream identityStorePath, char[] identityStorePassword, String identityStoreType) {
            return this.withIdentityMaterial(identityStorePath, identityStorePassword, identityStorePassword, identityStoreType);
        }

        public Builder withIdentityMaterial(InputStream identityStream, char[] identityStorePassword, char[] identityPassword, String identityStoreType) {
            if (Objects.isNull(identityStream) || this.isBlank(identityStoreType)) {
                throw new GenericKeyStoreException(IDENTITY_VALIDATION_EXCEPTION_MESSAGE);
            }
            KeyStore identity = KeyStoreUtils.loadKeyStore(identityStream, identityStorePassword, identityStoreType);
            KeyStoreHolder identityHolder = new KeyStoreHolder(identity, identityStorePassword, identityPassword);
            this.identities.add(identityHolder);
            return this;
        }

        public Builder withIdentityMaterial(KeyStore identityStore, char[] identityStorePassword) {
            return this.withIdentityMaterial(identityStore, identityStorePassword, identityStorePassword);
        }

        public Builder withIdentityMaterial(KeyStore identityStore, char[] identityStorePassword, char[] identityPassword) {
            this.validateKeyStore(identityStore, IDENTITY_VALIDATION_EXCEPTION_MESSAGE);
            KeyStoreHolder identityHolder = new KeyStoreHolder(identityStore, identityStorePassword, identityPassword);
            this.identities.add(identityHolder);
            return this;
        }

        public Builder withIdentityMaterial(Key privateKey, char[] privateKeyPassword, Certificate ... certificateChain) {
            KeyStore identityStore = KeyStoreUtils.createIdentityStore(privateKey, privateKeyPassword, certificateChain);
            this.identities.add(new KeyStoreHolder(identityStore, "dummy-password".toCharArray(), privateKeyPassword));
            return this;
        }

        public <T extends X509KeyManager> Builder withIdentityMaterial(T keyManager) {
            this.identityManagers.add(KeyManagerUtils.wrapIfNeeded(keyManager));
            return this;
        }

        public <T extends KeyManagerFactory> Builder withIdentityMaterial(T keyManagerFactory) {
            X509ExtendedKeyManager keyManager = KeyManagerUtils.getKeyManager(keyManagerFactory);
            this.identityManagers.add(keyManager);
            return this;
        }

        private void validateKeyStore(KeyStore keyStore, String exceptionMessage) {
            if (Objects.isNull(keyStore)) {
                throw new GenericKeyStoreException(exceptionMessage);
            }
        }

        public <T extends HostnameVerifier> Builder withHostnameVerifier(T hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder withCiphers(String ... ciphers) {
            this.sslParameters.setCipherSuites(ciphers);
            return this;
        }

        public Builder withProtocols(String ... protocols) {
            this.sslParameters.setProtocols(protocols);
            return this;
        }

        public Builder withSslContextProtocol(String sslContextProtocol) {
            this.sslContextProtocol = sslContextProtocol;
            return this;
        }

        public <T extends Provider> Builder withSecurityProvider(T securityProvider) {
            this.securityProvider = securityProvider;
            return this;
        }

        public Builder withSecurityProvider(String securityProviderName) {
            this.securityProviderName = securityProviderName;
            return this;
        }

        public <T extends SecureRandom> Builder withSecureRandom(T secureRandom) {
            this.secureRandom = secureRandom;
            return this;
        }

        public Builder withTrustingAllCertificatesWithoutValidation() {
            LOGGER.warn("UnsafeTrustManager is being used. Client/Server certificates will be accepted without validation. Please don't use this configuration at production.");
            this.trustManagers.add(TrustManagerUtils.createUnsafeTrustManager());
            return this;
        }

        public Builder withPasswordCaching() {
            this.passwordCachingEnabled = true;
            return this;
        }

        public SSLFactory build() {
            if (!this.isIdentityMaterialPresent() && !this.isTrustMaterialPresent()) {
                throw new GenericSecurityException(IDENTITY_AND_TRUST_MATERIAL_VALIDATION_EXCEPTION_MESSAGE);
            }
            X509ExtendedKeyManager keyManager = this.isIdentityMaterialPresent() ? this.createKeyManager() : null;
            X509ExtendedTrustManager trustManager = this.isTrustMaterialPresent() ? this.createTrustManagers() : null;
            SSLContext sslContext = SSLContextUtils.createSslContext(keyManager, trustManager, this.secureRandom, this.sslContextProtocol, this.securityProviderName, this.securityProvider);
            KeyManagerFactory keyManagerFactory = Optional.ofNullable(keyManager).map(KeyManagerUtils::createKeyManagerFactory).orElse(null);
            TrustManagerFactory trustManagerFactory = Optional.ofNullable(trustManager).map(TrustManagerUtils::createTrustManagerFactory).orElse(null);
            SSLParameters baseSslParameters = this.merge(sslContext.getDefaultSSLParameters(), this.sslParameters);
            SSLSocketFactory sslSocketFactory = SocketUtils.createSslSocketFactory(sslContext.getSocketFactory(), baseSslParameters);
            SSLServerSocketFactory sslServerSocketFactory = SocketUtils.createSslServerSocketFactory(sslContext.getServerSocketFactory(), baseSslParameters);
            List<X509Certificate> trustedCertificates = Optional.ofNullable(trustManager).map(X509TrustManager::getAcceptedIssuers).flatMap(x509Certificates -> Optional.of(Arrays.asList(x509Certificates))).map(Collections::unmodifiableList).orElse(Collections.emptyList());
            if (!this.passwordCachingEnabled && !this.identities.isEmpty()) {
                KeyStoreUtils.sanitizeKeyStores(this.identities);
            }
            if (!this.passwordCachingEnabled && !this.trustStores.isEmpty()) {
                KeyStoreUtils.sanitizeKeyStores(this.trustStores);
            }
            IdentityMaterial identityMaterial = new IdentityMaterial.Builder().withKeyManager(keyManager).withKeyManagerFactory(keyManagerFactory).withIdentities(Collections.unmodifiableList(this.identities)).build();
            TrustMaterial trustMaterial = new TrustMaterial.Builder().withTrustManager(trustManager).withTrustManagerFactory(trustManagerFactory).withTrustStores(Collections.unmodifiableList(this.trustStores)).withTrustedCertificates(trustedCertificates).build();
            SSLMaterial sslMaterial = new SSLMaterial.Builder().withSslContext(sslContext).withSslSocketFactory(sslSocketFactory).withSslServerSocketFactory(sslServerSocketFactory).withIdentityMaterial(identityMaterial).withTrustMaterial(trustMaterial).withSslParameters(baseSslParameters).withHostnameVerifier(this.hostnameVerifier).withCiphers(Collections.unmodifiableList(Arrays.asList(baseSslParameters.getCipherSuites()))).withProtocols(Collections.unmodifiableList(Arrays.asList(baseSslParameters.getProtocols()))).build();
            return new SSLFactory(sslMaterial);
        }

        private boolean isTrustMaterialPresent() {
            return !this.trustStores.isEmpty() || !this.trustManagers.isEmpty();
        }

        private boolean isIdentityMaterialPresent() {
            return !this.identities.isEmpty() || !this.identityManagers.isEmpty();
        }

        private boolean isBlank(CharSequence charSequence) {
            int length;
            int n = length = Objects.isNull(charSequence) ? 0 : charSequence.length();
            if (length != 0) {
                for (int i = 0; i < length; ++i) {
                    if (Character.isWhitespace(charSequence.charAt(i))) continue;
                    return false;
                }
            }
            return true;
        }

        private X509ExtendedKeyManager createKeyManager() {
            return KeyManagerUtils.keyManagerBuilder().withKeyManagers(this.identityManagers).withIdentities(this.identities).build();
        }

        private X509ExtendedTrustManager createTrustManagers() {
            return TrustManagerUtils.trustManagerBuilder().withTrustManagers(this.trustManagers).withTrustStores(this.trustStores.stream().map(KeyStoreHolder::getKeyStore).collect(Collectors.toList())).build();
        }

        private SSLParameters merge(SSLParameters defaultSslParameters, SSLParameters factorySslParameters) {
            SSLParameters baseSslParameters = new SSLParameters();
            String[] ciphers = Optional.ofNullable(factorySslParameters.getCipherSuites()).orElse(defaultSslParameters.getCipherSuites());
            String[] protocols = Optional.ofNullable(factorySslParameters.getProtocols()).orElse(defaultSslParameters.getProtocols());
            baseSslParameters.setCipherSuites(ciphers);
            baseSslParameters.setProtocols(protocols);
            return baseSslParameters;
        }
    }
}

