/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl;

import java.io.IOException;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import nl.altindag.ssl.exception.GenericKeyStoreException;
import nl.altindag.ssl.exception.GenericSSLContextException;
import nl.altindag.ssl.exception.GenericSecurityException;
import nl.altindag.ssl.keymanager.CompositeX509ExtendedKeyManager;
import nl.altindag.ssl.model.KeyStoreHolder;
import nl.altindag.ssl.socket.CompositeSSLServerSocketFactory;
import nl.altindag.ssl.socket.CompositeSSLSocketFactory;
import nl.altindag.ssl.trustmanager.CompositeX509ExtendedTrustManager;
import nl.altindag.ssl.util.KeyStoreUtils;
import nl.altindag.ssl.util.TrustManagerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SSLFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSLFactory.class);
    private static final char[] EMPTY_PASSWORD = new char[0];
    private final String sslContextProtocol;
    private final Provider securityProvider;
    private final String securityProviderName;
    private final SecureRandom secureRandom;
    private final HostnameVerifier hostnameVerifier;
    private final List<KeyStoreHolder> identities = new ArrayList<KeyStoreHolder>();
    private final List<X509ExtendedKeyManager> identityManagers = new ArrayList<X509ExtendedKeyManager>();
    private final List<KeyStoreHolder> trustStores = new ArrayList<KeyStoreHolder>();
    private final List<X509ExtendedTrustManager> trustManagers = new ArrayList<X509ExtendedTrustManager>();
    private final boolean passwordCachingEnabled;
    private final SSLParameters sslParameters;
    private SSLContext sslContext;
    private CompositeSSLSocketFactory sslSocketFactory;
    private CompositeSSLServerSocketFactory sslServerSocketFactory;
    private CompositeX509ExtendedTrustManager trustManager;
    private CompositeX509ExtendedKeyManager keyManager;
    private List<X509Certificate> trustedCertificates;
    private List<String> ciphers;
    private List<String> protocols;

    private SSLFactory(String sslContextProtocol, Provider securityProvider, String securityProviderName, SecureRandom secureRandom, HostnameVerifier hostnameVerifier, List<KeyStoreHolder> identities, List<X509ExtendedKeyManager> identityManagers, List<KeyStoreHolder> trustStores, List<X509ExtendedTrustManager> trustManagers, boolean passwordCachingEnabled, SSLParameters sslParameters) {
        this.sslContextProtocol = sslContextProtocol;
        this.securityProvider = securityProvider;
        this.securityProviderName = securityProviderName;
        this.secureRandom = secureRandom;
        this.hostnameVerifier = hostnameVerifier;
        this.identities.addAll(identities);
        this.identityManagers.addAll(identityManagers);
        this.trustStores.addAll(trustStores);
        this.trustManagers.addAll(trustManagers);
        this.passwordCachingEnabled = passwordCachingEnabled;
        this.sslParameters = sslParameters;
    }

    private void createSSLContextWithIdentityMaterial() {
        this.createSSLContext(this.createKeyManager(), null);
    }

    private void createSSLContextWithTrustMaterial() {
        this.createSSLContext(null, this.createTrustManagers());
    }

    private void createSSLContextWithIdentityMaterialAndTrustMaterial() {
        this.createSSLContext(this.createKeyManager(), this.createTrustManagers());
    }

    private void createSSLContext(KeyManager[] keyManagers, TrustManager[] trustManagers) {
        try {
            this.sslContext = Objects.nonNull(this.securityProvider) ? SSLContext.getInstance(this.sslContextProtocol, this.securityProvider) : (Objects.nonNull(this.securityProviderName) ? SSLContext.getInstance(this.sslContextProtocol, this.securityProviderName) : SSLContext.getInstance(this.sslContextProtocol));
            this.sslContext.init(keyManagers, trustManagers, this.secureRandom);
            this.postConstructRemainingSslMaterials();
        }
        catch (KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new GenericSSLContextException(e);
        }
    }

    private KeyManager[] createKeyManager() {
        this.keyManager = CompositeX509ExtendedKeyManager.builder().withKeyManagers(this.identityManagers).withIdentities(this.identities).build();
        if (!this.passwordCachingEnabled && !this.identities.isEmpty()) {
            this.sanitizeKeyStores(this.identities);
        }
        return new X509ExtendedKeyManager[]{this.keyManager};
    }

    private TrustManager[] createTrustManagers() {
        this.trustManager = CompositeX509ExtendedTrustManager.builder().withTrustManagers(this.trustManagers).withTrustStores(this.trustStores.stream().map(KeyStoreHolder::getKeyStore).collect(Collectors.toList())).build();
        if (!this.passwordCachingEnabled && !this.trustStores.isEmpty()) {
            this.sanitizeKeyStores(this.trustStores);
        }
        return new TrustManager[]{this.trustManager};
    }

    private void sanitizeKeyStores(List<KeyStoreHolder> keyStores) {
        List sanitizedKeyStores = keyStores.stream().map(keyStoreHolder -> new KeyStoreHolder(keyStoreHolder.getKeyStore(), EMPTY_PASSWORD, EMPTY_PASSWORD)).collect(Collectors.toList());
        keyStores.clear();
        keyStores.addAll(sanitizedKeyStores);
    }

    private void postConstructRemainingSslMaterials() {
        this.reinitializeSslParameters();
        this.sslSocketFactory = new CompositeSSLSocketFactory(this.sslContext.getSocketFactory(), this.sslParameters);
        this.sslServerSocketFactory = new CompositeSSLServerSocketFactory(this.sslContext.getServerSocketFactory(), this.sslParameters);
        this.trustedCertificates = Optional.ofNullable(this.trustManager).map(X509TrustManager::getAcceptedIssuers).flatMap(x509Certificates -> Optional.of(Arrays.asList(x509Certificates))).map(Collections::unmodifiableList).orElse(Collections.emptyList());
    }

    private void reinitializeSslParameters() {
        SSLParameters defaultSSLParameters = this.sslContext.getDefaultSSLParameters();
        String[] someCiphers = Optional.ofNullable(this.sslParameters.getCipherSuites()).orElse(defaultSSLParameters.getCipherSuites());
        String[] someProtocols = Optional.ofNullable(this.sslParameters.getProtocols()).orElse(defaultSSLParameters.getProtocols());
        this.sslParameters.setCipherSuites(someCiphers);
        this.sslParameters.setProtocols(someProtocols);
        this.ciphers = Collections.unmodifiableList(Arrays.asList(someCiphers));
        this.protocols = Collections.unmodifiableList(Arrays.asList(someProtocols));
    }

    public List<KeyStoreHolder> getIdentities() {
        return Collections.unmodifiableList(this.identities);
    }

    public List<KeyStoreHolder> getTrustStores() {
        return Collections.unmodifiableList(this.trustStores);
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public SSLServerSocketFactory getSslServerSocketFactory() {
        return this.sslServerSocketFactory;
    }

    public Optional<X509ExtendedKeyManager> getKeyManager() {
        return Optional.ofNullable(this.keyManager);
    }

    public Optional<X509ExtendedTrustManager> getTrustManager() {
        return Optional.ofNullable(this.trustManager);
    }

    public List<X509Certificate> getTrustedCertificates() {
        return this.trustedCertificates;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public List<String> getCiphers() {
        return this.ciphers;
    }

    public List<String> getProtocols() {
        return this.protocols;
    }

    public SSLParameters getSslParameters() {
        return this.sslParameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final String TRUST_STORE_VALIDATION_EXCEPTION_MESSAGE = "TrustStore details are empty, which are required to be present when SSL/TLS is enabled";
        private static final String IDENTITY_VALIDATION_EXCEPTION_MESSAGE = "Identity details are empty, which are required to be present when SSL/TLS is enabled";
        private static final String KEY_STORE_LOADING_EXCEPTION = "Failed to load the keystore";
        private static final String KEY_MANAGER_FACTORY_EXCEPTION = "KeyManagerFactory does not contain any KeyManagers of type X509ExtendedKeyManager";
        private static final String TRUST_MANAGER_FACTORY_EXCEPTION = "TrustManagerFactory does not contain any TrustManagers of type X509ExtendedTrustManager";
        private static final String IDENTITY_AND_TRUST_MATERIAL_VALIDATION_EXCEPTION_MESSAGE = "Could not create instance of SSLFactory because Identity and Trust material are not present. Please provide at least a Trust material.";
        private String sslContextProtocol = "TLS";
        private Provider securityProvider = null;
        private String securityProviderName = null;
        private SecureRandom secureRandom = null;
        private HostnameVerifier hostnameVerifier = (host, sslSession) -> host.equalsIgnoreCase(sslSession.getPeerHost());
        private final List<KeyStoreHolder> identities = new ArrayList<KeyStoreHolder>();
        private final List<KeyStoreHolder> trustStores = new ArrayList<KeyStoreHolder>();
        private final List<X509ExtendedKeyManager> identityManagers = new ArrayList<X509ExtendedKeyManager>();
        private final List<X509ExtendedTrustManager> trustManagers = new ArrayList<X509ExtendedTrustManager>();
        private final SSLParameters sslParameters = new SSLParameters();
        private boolean passwordCachingEnabled = false;

        private Builder() {
        }

        public Builder withSystemTrustMaterial() {
            this.trustManagers.add(TrustManagerUtils.createTrustManagerWithSystemTrustedCertificates());
            return this;
        }

        public Builder withDefaultTrustMaterial() {
            this.trustManagers.add(TrustManagerUtils.createTrustManagerWithJdkTrustedCertificates());
            return this;
        }

        public <T extends X509ExtendedTrustManager> Builder withTrustMaterial(T trustManager) {
            this.trustManagers.add(trustManager);
            return this;
        }

        public <T extends TrustManagerFactory> Builder withTrustMaterial(T trustManagerFactory) {
            TrustManager[] trustManagersFromFactory = trustManagerFactory.getTrustManagers();
            boolean isTrustManagerAdded = false;
            for (TrustManager trustManager : trustManagersFromFactory) {
                if (!(trustManager instanceof X509ExtendedTrustManager)) continue;
                this.trustManagers.add((X509ExtendedTrustManager)trustManager);
                isTrustManagerAdded = true;
            }
            if (!isTrustManagerAdded) {
                throw new GenericSecurityException(TRUST_MANAGER_FACTORY_EXCEPTION);
            }
            return this;
        }

        public Builder withTrustMaterial(String trustStorePath, char[] trustStorePassword) {
            return this.withTrustMaterial(trustStorePath, trustStorePassword, KeyStore.getDefaultType());
        }

        public Builder withTrustMaterial(String trustStorePath, char[] trustStorePassword, String trustStoreType) {
            if (this.isBlank(trustStorePath)) {
                throw new GenericKeyStoreException(TRUST_STORE_VALIDATION_EXCEPTION_MESSAGE);
            }
            try {
                KeyStore trustStore = KeyStoreUtils.loadKeyStore(trustStorePath, trustStorePassword, trustStoreType);
                KeyStoreHolder trustStoreHolder = new KeyStoreHolder(trustStore, trustStorePassword);
                this.trustStores.add(trustStoreHolder);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new GenericKeyStoreException(KEY_STORE_LOADING_EXCEPTION, e);
            }
            return this;
        }

        public Builder withTrustMaterial(Path trustStorePath, char[] trustStorePassword) {
            return this.withTrustMaterial(trustStorePath, trustStorePassword, KeyStore.getDefaultType());
        }

        public Builder withTrustMaterial(Path trustStorePath, char[] trustStorePassword, String trustStoreType) {
            if (Objects.isNull(trustStorePath) || this.isBlank(trustStoreType)) {
                throw new GenericKeyStoreException(TRUST_STORE_VALIDATION_EXCEPTION_MESSAGE);
            }
            try {
                KeyStore trustStore = KeyStoreUtils.loadKeyStore(trustStorePath, trustStorePassword, trustStoreType);
                KeyStoreHolder trustStoreHolder = new KeyStoreHolder(trustStore, trustStorePassword);
                this.trustStores.add(trustStoreHolder);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new GenericKeyStoreException(KEY_STORE_LOADING_EXCEPTION, e);
            }
            return this;
        }

        public Builder withTrustMaterial(KeyStore trustStore) {
            this.withTrustMaterial(trustStore, EMPTY_PASSWORD);
            return this;
        }

        public Builder withTrustMaterial(KeyStore trustStore, char[] trustStorePassword) {
            this.validateKeyStore(trustStore, TRUST_STORE_VALIDATION_EXCEPTION_MESSAGE);
            KeyStoreHolder trustStoreHolder = new KeyStoreHolder(trustStore, trustStorePassword);
            this.trustStores.add(trustStoreHolder);
            return this;
        }

        @SafeVarargs
        public final <T extends Certificate> Builder withTrustMaterial(T ... certificates) {
            return this.withTrustMaterial(Arrays.asList(certificates));
        }

        public <T extends Certificate> Builder withTrustMaterial(List<T> certificates) {
            try {
                KeyStore trustStore = KeyStoreUtils.createTrustStore(certificates);
                KeyStoreHolder trustStoreHolder = new KeyStoreHolder(trustStore, "dummy-password".toCharArray());
                this.trustStores.add(trustStoreHolder);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new GenericKeyStoreException(e);
            }
            return this;
        }

        public Builder withIdentityMaterial(String identityStorePath, char[] identityStorePassword) {
            return this.withIdentityMaterial(identityStorePath, identityStorePassword, identityStorePassword, KeyStore.getDefaultType());
        }

        public Builder withIdentityMaterial(String identityStorePath, char[] identityStorePassword, char[] identityPassword) {
            return this.withIdentityMaterial(identityStorePath, identityStorePassword, identityPassword, KeyStore.getDefaultType());
        }

        public Builder withIdentityMaterial(String identityStorePath, char[] identityStorePassword, String identityStoreType) {
            return this.withIdentityMaterial(identityStorePath, identityStorePassword, identityStorePassword, identityStoreType);
        }

        public Builder withIdentityMaterial(String identityStorePath, char[] identityStorePassword, char[] identityPassword, String identityStoreType) {
            if (this.isBlank(identityStorePath) || this.isBlank(identityStoreType)) {
                throw new GenericKeyStoreException(IDENTITY_VALIDATION_EXCEPTION_MESSAGE);
            }
            try {
                KeyStore identity = KeyStoreUtils.loadKeyStore(identityStorePath, identityStorePassword, identityStoreType);
                KeyStoreHolder identityHolder = new KeyStoreHolder(identity, identityStorePassword, identityPassword);
                this.identities.add(identityHolder);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new GenericKeyStoreException(KEY_STORE_LOADING_EXCEPTION, e);
            }
            return this;
        }

        public Builder withIdentityMaterial(Path identityStorePath, char[] identityStorePassword) {
            return this.withIdentityMaterial(identityStorePath, identityStorePassword, identityStorePassword, KeyStore.getDefaultType());
        }

        public Builder withIdentityMaterial(Path identityStorePath, char[] identityStorePassword, char[] identityPassword) {
            return this.withIdentityMaterial(identityStorePath, identityStorePassword, identityPassword, KeyStore.getDefaultType());
        }

        public Builder withIdentityMaterial(Path identityStorePath, char[] identityStorePassword, String identityStoreType) {
            return this.withIdentityMaterial(identityStorePath, identityStorePassword, identityStorePassword, identityStoreType);
        }

        public Builder withIdentityMaterial(Path identityStorePath, char[] identityStorePassword, char[] identityPassword, String identityStoreType) {
            if (Objects.isNull(identityStorePath) || this.isBlank(identityStoreType)) {
                throw new GenericKeyStoreException(IDENTITY_VALIDATION_EXCEPTION_MESSAGE);
            }
            try {
                KeyStore identity = KeyStoreUtils.loadKeyStore(identityStorePath, identityStorePassword, identityStoreType);
                KeyStoreHolder identityHolder = new KeyStoreHolder(identity, identityStorePassword, identityPassword);
                this.identities.add(identityHolder);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new GenericKeyStoreException(KEY_STORE_LOADING_EXCEPTION, e);
            }
            return this;
        }

        public Builder withIdentityMaterial(KeyStore identityStore, char[] identityStorePassword) {
            return this.withIdentityMaterial(identityStore, identityStorePassword, identityStorePassword);
        }

        public Builder withIdentityMaterial(KeyStore identityStore, char[] identityStorePassword, char[] identityPassword) {
            this.validateKeyStore(identityStore, IDENTITY_VALIDATION_EXCEPTION_MESSAGE);
            KeyStoreHolder identityHolder = new KeyStoreHolder(identityStore, identityStorePassword, identityPassword);
            this.identities.add(identityHolder);
            return this;
        }

        public Builder withIdentityMaterial(PrivateKey privateKey, char[] privateKeyPassword, Certificate ... certificateChain) {
            try {
                KeyStore identityStore = KeyStoreUtils.createIdentityStore(privateKey, privateKeyPassword, certificateChain);
                this.identities.add(new KeyStoreHolder(identityStore, "dummy-password".toCharArray(), privateKeyPassword));
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new GenericKeyStoreException(e);
            }
            return this;
        }

        public <T extends X509ExtendedKeyManager> Builder withIdentityMaterial(T keyManager) {
            this.identityManagers.add(keyManager);
            return this;
        }

        public <T extends KeyManagerFactory> Builder withIdentityMaterial(T keyManagerFactory) {
            KeyManager[] keyManagersFromFactory = keyManagerFactory.getKeyManagers();
            boolean isKeyManagerAdded = false;
            for (KeyManager keyManager : keyManagersFromFactory) {
                if (!(keyManager instanceof X509ExtendedKeyManager)) continue;
                this.identityManagers.add((X509ExtendedKeyManager)keyManager);
                isKeyManagerAdded = true;
            }
            if (!isKeyManagerAdded) {
                throw new GenericSecurityException(KEY_MANAGER_FACTORY_EXCEPTION);
            }
            return this;
        }

        private void validateKeyStore(KeyStore keyStore, String exceptionMessage) {
            if (Objects.isNull(keyStore)) {
                throw new GenericKeyStoreException(exceptionMessage);
            }
        }

        public <T extends HostnameVerifier> Builder withHostnameVerifier(T hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder withCiphers(String ... ciphers) {
            this.sslParameters.setCipherSuites(ciphers);
            return this;
        }

        public Builder withProtocols(String ... protocols) {
            this.sslParameters.setProtocols(protocols);
            return this;
        }

        public Builder withSslContextProtocol(String sslContextProtocol) {
            this.sslContextProtocol = sslContextProtocol;
            return this;
        }

        public <T extends Provider> Builder withSecurityProvider(T securityProvider) {
            this.securityProvider = securityProvider;
            return this;
        }

        public Builder withSecurityProvider(String securityProviderName) {
            this.securityProviderName = securityProviderName;
            return this;
        }

        public <T extends SecureRandom> Builder withSecureRandom(T secureRandom) {
            this.secureRandom = secureRandom;
            return this;
        }

        public Builder withTrustingAllCertificatesWithoutValidation() {
            LOGGER.warn("UnsafeTrustManager is being used. Client/Server certificates will be accepted without validation. Please don't use this configuration at production.");
            this.trustManagers.add(TrustManagerUtils.createUnsafeTrustManager());
            return this;
        }

        public Builder withPasswordCaching() {
            this.passwordCachingEnabled = true;
            return this;
        }

        public SSLFactory build() {
            if (this.isIdentityMaterialNotPresent() && this.isTrustMaterialNotPresent()) {
                throw new GenericSecurityException(IDENTITY_AND_TRUST_MATERIAL_VALIDATION_EXCEPTION_MESSAGE);
            }
            SSLFactory sslFactory = new SSLFactory(this.sslContextProtocol, this.securityProvider, this.securityProviderName, this.secureRandom, this.hostnameVerifier, this.identities, this.identityManagers, this.trustStores, this.trustManagers, this.passwordCachingEnabled, this.sslParameters);
            if (this.isIdentityMaterialPresent() && this.isTrustMaterialPresent()) {
                sslFactory.createSSLContextWithIdentityMaterialAndTrustMaterial();
            } else if (this.isIdentityMaterialPresent()) {
                sslFactory.createSSLContextWithIdentityMaterial();
            } else {
                sslFactory.createSSLContextWithTrustMaterial();
            }
            return sslFactory;
        }

        private boolean isTrustMaterialPresent() {
            return !this.trustStores.isEmpty() || !this.trustManagers.isEmpty();
        }

        private boolean isTrustMaterialNotPresent() {
            return !this.isTrustMaterialPresent();
        }

        private boolean isIdentityMaterialPresent() {
            return !this.identities.isEmpty() || !this.identityManagers.isEmpty();
        }

        private boolean isIdentityMaterialNotPresent() {
            return !this.isIdentityMaterialPresent();
        }

        private boolean isBlank(CharSequence charSequence) {
            int length;
            int n = length = Objects.isNull(charSequence) ? 0 : charSequence.length();
            if (length != 0) {
                for (int i = 0; i < length; ++i) {
                    if (Character.isWhitespace(charSequence.charAt(i))) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

