/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.sslcontext.util;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import nl.altindag.sslcontext.exception.GenericKeyStoreException;
import nl.altindag.sslcontext.exception.GenericSecurityException;
import nl.altindag.sslcontext.keymanager.CompositeX509ExtendedKeyManager;
import nl.altindag.sslcontext.model.KeyStoreHolder;

public final class KeyManagerUtils {
    private KeyManagerUtils() {
    }

    public static X509ExtendedKeyManager combine(X509ExtendedKeyManager ... keyManagers) {
        return KeyManagerUtils.combine(Arrays.asList(keyManagers));
    }

    public static X509ExtendedKeyManager combine(List<X509ExtendedKeyManager> keyManagers) {
        return CompositeX509ExtendedKeyManager.builder().withKeyManagers(keyManagers).build();
    }

    public static X509ExtendedKeyManager createKeyManager(KeyStoreHolder ... keyStoreHolders) {
        return Arrays.stream(keyStoreHolders).map(keyStoreHolder -> KeyManagerUtils.createKeyManager(keyStoreHolder.getKeyStore(), keyStoreHolder.getKeyStorePassword())).collect(Collectors.collectingAndThen(Collectors.toList(), KeyManagerUtils::combine));
    }

    public static X509ExtendedKeyManager createKeyManager(KeyStore keyStore, char[] keyStorePassword) {
        return KeyManagerUtils.createKeyManager(keyStore, keyStorePassword, KeyManagerFactory.getDefaultAlgorithm());
    }

    public static X509ExtendedKeyManager createKeyManager(KeyStore keyStore, char[] keyStorePassword, String algorithm) {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(algorithm);
            keyManagerFactory.init(keyStore, keyStorePassword);
            return Arrays.stream(keyManagerFactory.getKeyManagers()).filter(keyManager -> keyManager instanceof X509ExtendedKeyManager).map(keyManager -> (X509ExtendedKeyManager)keyManager).findFirst().orElseThrow(() -> new GenericKeyStoreException("Could not create a KeyManager with the provided keyStore and password"));
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new GenericSecurityException(e);
        }
    }
}

