/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.sslcontext.util;

import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.util.Arrays;
import java.util.Objects;
import javax.net.ssl.KeyManagerFactory;
import nl.altindag.sslcontext.SSLFactory;

public final class NettySslContextUtils {
    private NettySslContextUtils() {
    }

    public static SslContextBuilder forClient(SSLFactory sslFactory) {
        Objects.requireNonNull(sslFactory.getSslContext());
        SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().ciphers(Arrays.asList(sslFactory.getSslContext().getDefaultSSLParameters().getCipherSuites()), (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).protocols(sslFactory.getSslContext().getDefaultSSLParameters().getProtocols());
        if (sslFactory.isOneWayAuthenticationEnabled()) {
            sslContextBuilder.trustManager(sslFactory.getTrustManagerFactory());
        }
        if (sslFactory.isTwoWayAuthenticationEnabled()) {
            sslContextBuilder.keyManager(sslFactory.getKeyManagerFactory()).trustManager(sslFactory.getTrustManagerFactory());
        }
        return sslContextBuilder;
    }

    public static SslContextBuilder forServer(SSLFactory sslFactory) {
        Objects.requireNonNull(sslFactory.getSslContext());
        Objects.requireNonNull(sslFactory.getKeyManagerFactory());
        return SslContextBuilder.forServer((KeyManagerFactory)sslFactory.getKeyManagerFactory()).ciphers(Arrays.asList(sslFactory.getSslContext().getDefaultSSLParameters().getCipherSuites()), (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).protocols(sslFactory.getSslContext().getDefaultSSLParameters().getProtocols()).trustManager(sslFactory.getTrustManagerFactory());
    }
}

