/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.log.util;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import nl.altindag.log.appender.InMemoryAppender;

public final class AppenderUtils {
    public static final String CONSOLE_APPENDER_NAME = "console";
    public static final String IN_MEMORY_APPENDER_NAME = "logcaptor-in-memory-appender";
    private static final String DEFAULT_LOG_PATTERN = "%d{yyyy-MM-dd HH:mm:ss.SSSXXX} %-5level [%thread] %logger{36} - %msg%n";
    private static final List<String> CONSOLE_APPENDER_NAMES = Arrays.asList("console", "CONSOLE");

    private AppenderUtils() {
    }

    public static ConsoleAppender<ILoggingEvent> createConsoleAppender(LoggerContext loggerContext) {
        Encoder<ILoggingEvent> encoder = AppenderUtils.createEncoder(loggerContext);
        ConsoleAppender consoleAppender = new ConsoleAppender();
        consoleAppender.setContext((Context)loggerContext);
        consoleAppender.setName(CONSOLE_APPENDER_NAME);
        consoleAppender.setImmediateFlush(true);
        consoleAppender.setEncoder(encoder);
        consoleAppender.start();
        return consoleAppender;
    }

    public static Encoder<ILoggingEvent> createEncoder(LoggerContext loggerContext) {
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)loggerContext);
        encoder.setPattern(DEFAULT_LOG_PATTERN);
        encoder.start();
        return encoder;
    }

    public static Optional<ConsoleAppender<ILoggingEvent>> getConsoleAppender(Logger logger) {
        return CONSOLE_APPENDER_NAMES.stream().map(arg_0 -> ((Logger)logger).getAppender(arg_0)).filter(Objects::nonNull).filter(ConsoleAppender.class::isInstance).map(consoleAppender -> (ConsoleAppender)consoleAppender).findFirst();
    }

    public static InMemoryAppender<ILoggingEvent> configureInMemoryAppender(Logger logger, List<ILoggingEvent> eventsCollector) {
        InMemoryAppender<ILoggingEvent> inMemoryAppender = new InMemoryAppender<ILoggingEvent>(IN_MEMORY_APPENDER_NAME, eventsCollector);
        inMemoryAppender.setContext((Context)logger.getLoggerContext());
        inMemoryAppender.start();
        logger.addAppender(inMemoryAppender);
        return inMemoryAppender;
    }

    public static ConsoleAppender<ILoggingEvent> configureConsoleAppender(Logger logger) {
        return AppenderUtils.configureConsoleAppender(logger, null);
    }

    public static ConsoleAppender<ILoggingEvent> configureConsoleAppender(Logger logger, ConsoleAppender<ILoggingEvent> appender) {
        String loggerName = logger.getName();
        ConsoleAppender<ILoggingEvent> consoleAppender = AppenderUtils.createConsoleAppender(logger, appender);
        if (!"ROOT".equals(loggerName)) {
            boolean containsRootConsoleAppender = false;
            Iterator rootAppenders = AppenderUtils.getRootLogger(logger).iteratorForAppenders();
            while (rootAppenders.hasNext()) {
                if (!(rootAppenders.next() instanceof ConsoleAppender)) continue;
                containsRootConsoleAppender = true;
            }
            if (containsRootConsoleAppender) {
                logger.addAppender(consoleAppender);
            }
        }
        return consoleAppender;
    }

    private static ConsoleAppender<ILoggingEvent> createConsoleAppender(Logger logger, ConsoleAppender<ILoggingEvent> consoleAppender) {
        return Optional.ofNullable(consoleAppender).orElseGet(() -> AppenderUtils.getConsoleAppender(AppenderUtils.getRootLogger(logger)).orElseGet(() -> AppenderUtils.getConsoleAppender(logger).orElseGet(() -> AppenderUtils.createConsoleAppender(logger.getLoggerContext()))));
    }

    private static Logger getRootLogger(Logger logger) {
        return logger.getLoggerContext().getLogger("ROOT");
    }
}

