/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.filter.Filter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import nl.altindag.log.appender.InMemoryAppender;
import nl.altindag.log.model.LogEvent;
import nl.altindag.log.util.AppenderUtils;
import nl.altindag.log.util.JavaUtilLoggingLoggerUtils;
import nl.altindag.log.util.LogbackUtils;
import nl.altindag.log.util.Mappers;

public final class LogCaptor
implements AutoCloseable {
    private static final Map<String, Level> logLevelContainer = new HashMap<String, Level>();
    private final Logger logger;
    private final InMemoryAppender<ILoggingEvent> inMemoryAppender;
    private ConsoleAppender<ILoggingEvent> consoleAppender;
    private final List<ILoggingEvent> eventsCollector = new CopyOnWriteArrayList<ILoggingEvent>();

    private LogCaptor(String loggerName) {
        this.logger = LogbackUtils.getLogger(loggerName);
        this.inMemoryAppender = AppenderUtils.configureInMemoryAppender(this.logger, this.eventsCollector);
        this.consoleAppender = AppenderUtils.configureConsoleAppender(this.logger);
        JavaUtilLoggingLoggerUtils.redirectToSlf4j(loggerName);
        logLevelContainer.putIfAbsent(this.logger.getName(), this.logger.getEffectiveLevel());
    }

    public static LogCaptor forRoot() {
        return new LogCaptor("ROOT");
    }

    public static LogCaptor forClass(Class<?> clazz) {
        return new LogCaptor(clazz.getName());
    }

    public static LogCaptor forName(String name) {
        return new LogCaptor(name);
    }

    public List<String> getLogs() {
        return this.getLogs(logEvent -> true, ILoggingEvent::getFormattedMessage);
    }

    public List<String> getInfoLogs() {
        return this.getLogs(Level.INFO);
    }

    public List<String> getDebugLogs() {
        return this.getLogs(Level.DEBUG);
    }

    public List<String> getWarnLogs() {
        return this.getLogs(Level.WARN);
    }

    public List<String> getErrorLogs() {
        return this.getLogs(Level.ERROR);
    }

    public List<String> getTraceLogs() {
        return this.getLogs(Level.TRACE);
    }

    private List<String> getLogs(Level level) {
        return this.getLogs(logEvent -> logEvent.getLevel() == level, ILoggingEvent::getFormattedMessage);
    }

    public List<LogEvent> getLogEvents() {
        return this.getLogs(logEvent -> true, Mappers.toLogEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> getLogs(Predicate<ILoggingEvent> logEventPredicate, Function<ILoggingEvent, T> logEventMapper) {
        List<ILoggingEvent> list = this.eventsCollector;
        synchronized (list) {
            return this.eventsCollector.stream().filter(logEventPredicate).map(logEventMapper).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
    }

    public boolean hasMessage(String message) {
        return this.getLogs().stream().anyMatch(log -> log.contains(message));
    }

    public boolean hasInfoMessage(String message) {
        return this.hasMessage(Level.INFO, message);
    }

    public boolean hasDebugMessage(String message) {
        return this.hasMessage(Level.DEBUG, message);
    }

    public boolean hasWarnMessage(String message) {
        return this.hasMessage(Level.WARN, message);
    }

    public boolean hasErrorMessage(String message) {
        return this.hasMessage(Level.ERROR, message);
    }

    public boolean hasTraceMessage(String message) {
        return this.hasMessage(Level.TRACE, message);
    }

    private boolean hasMessage(Level level, String message) {
        return this.getLogs(logEvent -> logEvent.getLevel() == level, ILoggingEvent::getFormattedMessage).stream().anyMatch(log -> log.contains(message));
    }

    public void addFilter(Filter<ILoggingEvent> filter) {
        this.inMemoryAppender.addFilter(filter);
        filter.start();
    }

    public void setLogLevelToInfo() {
        this.logger.setLevel(Level.INFO);
    }

    public void setLogLevelToDebug() {
        this.logger.setLevel(Level.DEBUG);
    }

    public void setLogLevelToTrace() {
        this.logger.setLevel(Level.TRACE);
    }

    public void disableLogs() {
        this.logger.setLevel(Level.OFF);
    }

    public void disableConsoleOutput() {
        this.reconfigure();
        this.logger.detachAppender(this.consoleAppender);
        if (!"ROOT".equals(this.logger.getName())) {
            this.logger.setAdditive(false);
        }
    }

    public void enableConsoleOutput() {
        this.reconfigure();
        if (!"ROOT".equals(this.logger.getName())) {
            this.logger.setAdditive(false);
        }
    }

    Logger getRootLogger() {
        return this.logger.getLoggerContext().getLogger("ROOT");
    }

    Logger getLogger() {
        return this.logger;
    }

    public void resetLogLevel() {
        Optional.ofNullable(logLevelContainer.get(this.logger.getName())).ifPresent(arg_0 -> ((Logger)this.logger).setLevel(arg_0));
    }

    public void clearLogs() {
        this.eventsCollector.clear();
    }

    public void reconfigure() {
        StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.logger.iteratorForAppenders(), 16), false).filter(appender -> appender instanceof ConsoleAppender || appender instanceof InMemoryAppender).forEach(arg_0 -> ((Logger)this.logger).detachAppender(arg_0));
        this.consoleAppender = AppenderUtils.configureConsoleAppender(this.logger, this.consoleAppender);
        this.logger.addAppender(this.inMemoryAppender);
        this.logger.addAppender(this.consoleAppender);
        this.logger.setAdditive(true);
        this.inMemoryAppender.start();
        this.consoleAppender.start();
    }

    @Override
    public void close() {
        this.logger.detachAppender(this.inMemoryAppender);
        this.inMemoryAppender.stop();
        if (!"ROOT".equals(this.logger.getName())) {
            this.logger.setAdditive(true);
            this.logger.detachAppender(this.consoleAppender);
        }
    }

    public String toString() {
        return "LogCaptor(loggerName=" + this.logger.getName() + ")";
    }
}

