/*
 * Decompiled with CFR 0.152.
 */
package io.github.habeebcycle.querybuilder;

import io.github.habeebcycle.querybuilder.fragment.QueryFragment;
import io.github.habeebcycle.querybuilder.keyword.FilterExpression;
import io.github.habeebcycle.querybuilder.keyword.QueryKeyword;
import io.github.habeebcycle.querybuilder.utils.Constant;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class FilterBuilder {
    private final List<QueryFragment> queryFragment = new ArrayList<QueryFragment>();

    public FilterBuilder filterExpression(String field, FilterExpression expression, Object value) {
        return this.filterExpressions(field, expression, List.of(value));
    }

    public FilterBuilder filterExpressions(String field, FilterExpression expression, Object ... value) {
        return this.filterExpressions(field, expression, List.of(value));
    }

    public FilterBuilder filterExpressions(String field, FilterExpression expression, List<Object> values) {
        String fragment = null;
        for (Object o : values) {
            fragment = String.format("%s %s %s", field, expression.getExpression(), this.computeFragmentValue(o));
            this.queryFragment.add(new QueryFragment(QueryKeyword.FILTER, fragment));
        }
        return this;
    }

    public FilterBuilder filterPhrase(String phrase) {
        return this.filterPhrases(List.of(phrase));
    }

    public FilterBuilder filterPhrases(String ... phrases) {
        return this.filterPhrases(List.of(phrases));
    }

    public FilterBuilder filterPhrases(List<String> phrases) {
        for (String phrase : phrases) {
            this.queryFragment.add(new QueryFragment(QueryKeyword.FILTER, phrase));
        }
        return this;
    }

    public FilterBuilder and(Function<FilterBuilder, FilterBuilder> filter) {
        this.queryFragment.add(new QueryFragment(QueryKeyword.FILTER, String.format("(%s)", filter.apply(new FilterBuilder()).toQuery(Constant.AND))));
        return this;
    }

    public FilterBuilder or(Function<FilterBuilder, FilterBuilder> filter) {
        this.queryFragment.add(new QueryFragment(QueryKeyword.FILTER, String.format("(%s)", filter.apply(new FilterBuilder()).toQuery(Constant.OR))));
        return this;
    }

    public String toQuery(String operator) {
        if (this.queryFragment.isEmpty()) {
            return "";
        }
        return this.queryFragment.stream().map(QueryFragment::getValue).collect(Collectors.joining(String.format(" %s ", operator)));
    }

    private String computeFragmentValue(Object value) {
        if (value instanceof String) {
            return String.format("'%s'", value);
        }
        return value.toString();
    }
}

