/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.typeFunctions;

import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.graphQLProcessors.GraphQLInputProcessor;
import graphql.annotations.processor.graphQLProcessors.GraphQLOutputProcessor;
import graphql.annotations.processor.typeFunctions.TypeFunction;
import graphql.annotations.processor.util.NamingKit;
import graphql.schema.GraphQLType;
import java.lang.reflect.AnnotatedType;

public class ObjectFunction
implements TypeFunction {
    private GraphQLInputProcessor graphQLInputProcessor;
    private GraphQLOutputProcessor graphQLOutputProcessor;

    public ObjectFunction(GraphQLInputProcessor graphQLInputProcessor, GraphQLOutputProcessor graphQLOutputProcessor) {
        this.graphQLInputProcessor = graphQLInputProcessor;
        this.graphQLOutputProcessor = graphQLOutputProcessor;
    }

    @Override
    public String getTypeName(Class<?> aClass, AnnotatedType annotatedType) {
        GraphQLName name = aClass.getAnnotation(GraphQLName.class);
        return NamingKit.toGraphqlName(name == null ? aClass.getSimpleName() : name.value());
    }

    @Override
    public boolean canBuildType(Class<?> aClass, AnnotatedType annotatedType) {
        return true;
    }

    @Override
    public GraphQLType buildType(boolean inputType, Class<?> aClass, AnnotatedType annotatedType, ProcessingElementsContainer container) {
        if (inputType) {
            return this.graphQLInputProcessor.getInputTypeOrRef(aClass, container);
        }
        return this.graphQLOutputProcessor.getOutputTypeOrRef(aClass, container);
    }
}

