/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.dataFetchers.connection;

import graphql.annotations.dataFetchers.connection.Connection;
import graphql.annotations.processor.util.Base64;
import graphql.annotations.processor.util.RelayKit;
import graphql.relay.ConnectionCursor;
import graphql.relay.DefaultConnection;
import graphql.relay.DefaultConnectionCursor;
import graphql.relay.DefaultEdge;
import graphql.relay.DefaultPageInfo;
import graphql.relay.Edge;
import graphql.relay.PageInfo;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StreamConnection
implements DataFetcher,
Connection {
    private final Stream<?> stream;
    private static final String DUMMY_CURSOR_PREFIX = "stream-cursor";

    public StreamConnection(Stream<?> stream) {
        this.stream = stream;
    }

    private Stream<Edge<Object>> buildEdges() {
        AtomicInteger ix = new AtomicInteger();
        return this.stream.map(obj -> {
            DefaultConnectionCursor connectionCursor = new DefaultConnectionCursor(this.createCursor(ix.incrementAndGet()));
            return new DefaultEdge(obj, (ConnectionCursor)connectionCursor);
        });
    }

    public Object get(DataFetchingEnvironment environment) {
        int afterOffset = this.getOffsetFromCursor((String)environment.getArgument("after"), 0);
        int beforeOffset = this.getOffsetFromCursor((String)environment.getArgument("before"), Integer.MAX_VALUE);
        Stream<Edge<Object>> edgesStream = this.buildEdges().skip(afterOffset).limit(beforeOffset - afterOffset);
        List edges = edgesStream.collect(Collectors.toList());
        if (edges.size() == 0) {
            return RelayKit.EMPTY_CONNECTION;
        }
        Integer first = (Integer)environment.getArgument("first");
        Integer last = (Integer)environment.getArgument("last");
        ConnectionCursor firstPresliceCursor = ((Edge)edges.get(0)).getCursor();
        ConnectionCursor lastPresliceCursor = ((Edge)edges.get(edges.size() - 1)).getCursor();
        if (first != null) {
            edges = edges.subList(0, first <= edges.size() ? first.intValue() : edges.size());
        }
        if (last != null) {
            edges = edges.subList(edges.size() - last, edges.size());
        }
        if (edges.size() == 0) {
            return RelayKit.EMPTY_CONNECTION;
        }
        Edge firstEdge = (Edge)edges.get(0);
        Edge lastEdge = (Edge)edges.get(edges.size() - 1);
        boolean hasPrevious = !firstEdge.getCursor().equals(firstPresliceCursor);
        boolean hasNext = !lastEdge.getCursor().equals(lastPresliceCursor);
        DefaultPageInfo pageInfo = new DefaultPageInfo(firstEdge.getCursor(), lastEdge.getCursor(), hasPrevious, hasNext);
        return new DefaultConnection(edges, (PageInfo)pageInfo);
    }

    private int getOffsetFromCursor(String cursor, int defaultValue) {
        if (cursor == null) {
            return defaultValue;
        }
        String string = Base64.fromBase64(cursor);
        return Integer.parseInt(string.substring(DUMMY_CURSOR_PREFIX.length()));
    }

    private String createCursor(int offset) {
        return Base64.toBase64(DUMMY_CURSOR_PREFIX + Integer.toString(offset));
    }
}

