/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.dataFetchers.connection;

import graphql.annotations.connection.ConnectionFetcher;
import graphql.annotations.processor.util.ReflectionKit;
import graphql.relay.Connection;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Optional;

public class ConnectionDataFetcher<T>
implements DataFetcher<Connection<T>> {
    private final DataFetcher<?> actualDataFetcher;
    private final Constructor<ConnectionFetcher<T>> constructor;

    public ConnectionDataFetcher(Class<? extends ConnectionFetcher<T>> connection, DataFetcher<?> actualDataFetcher) {
        this.actualDataFetcher = actualDataFetcher;
        Optional<Constructor> constructor = Arrays.stream(connection.getConstructors()).filter(c -> c.getParameterCount() == 1).map(c -> c).findFirst();
        if (!constructor.isPresent()) {
            throw new IllegalArgumentException(connection.getSimpleName() + " doesn't have a single argument constructor");
        }
        this.constructor = constructor.get();
    }

    public Connection<T> get(DataFetchingEnvironment environment) {
        ConnectionFetcher<T> conn = ReflectionKit.constructNewInstance(this.constructor, this.actualDataFetcher);
        return (Connection)conn.get(environment);
    }
}

