/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.typeBuilders;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.processor.retrievers.GraphQLObjectInfoRetriever;
import graphql.schema.GraphQLEnumType;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;

public class EnumBuilder {
    private GraphQLObjectInfoRetriever graphQLObjectInfoRetriever;

    public EnumBuilder(GraphQLObjectInfoRetriever graphQLObjectInfoRetriever) {
        this.graphQLObjectInfoRetriever = graphQLObjectInfoRetriever;
    }

    public GraphQLEnumType.Builder getEnumBuilder(Class<?> aClass) {
        String typeName = this.graphQLObjectInfoRetriever.getTypeName(aClass);
        Class<?> enumClass = aClass;
        GraphQLEnumType.Builder builder = GraphQLEnumType.newEnum();
        builder.name(typeName);
        GraphQLDescription description = aClass.getAnnotation(GraphQLDescription.class);
        if (description != null) {
            builder.description(description.value());
        }
        List<?> constants = Arrays.asList(enumClass.getEnumConstants());
        Arrays.stream(enumClass.getEnumConstants()).map(Enum::name).forEachOrdered(n -> {
            try {
                Field field = aClass.getField((String)n);
                GraphQLName fieldName = field.getAnnotation(GraphQLName.class);
                GraphQLDescription fieldDescription = field.getAnnotation(GraphQLDescription.class);
                Enum constant = constants.stream().filter(c -> c.name().contentEquals((CharSequence)n)).findFirst().get();
                String name_ = fieldName == null ? n : fieldName.value();
                builder.value(name_, (Object)constant, fieldDescription == null ? name_ : fieldDescription.value());
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        });
        return builder;
    }
}

