/*
 * Decompiled with CFR 0.152.
 */
package com.gongbo.export.core.provider.easyexcel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.WriteContext;
import com.alibaba.excel.enums.WriteTypeEnum;
import com.alibaba.excel.exception.ExcelGenerateException;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.gongbo.export.core.provider.ExportProvider;
import com.gongbo.export.core.provider.easyexcel.overrides.MyExcelWriteFillExecutor;
import com.gongbo.export.entity.ExportContext;
import com.gongbo.export.entity.ExportFieldInfo;
import com.gongbo.export.entity.fill.ExportFillData;
import com.gongbo.export.exception.FillKeyNotFoundException;
import com.gongbo.export.utils.CollectionUtil;
import com.gongbo.export.utils.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.core.io.ClassPathResource;

public class EasyExcelProvider
implements ExportProvider {
    private static final EasyExcelProvider INSTANCE = new EasyExcelProvider();

    public static EasyExcelProvider getInstance() {
        return INSTANCE;
    }

    @Override
    public ExportFieldInfo findExportFieldInfo(Field field) {
        ExcelProperty exportField = field.getAnnotation(ExcelProperty.class);
        if (exportField != null) {
            String name = null;
            CharSequence[] value = exportField.value();
            if (value.length > 0) {
                name = String.join((CharSequence)".", value);
            }
            return ExportFieldInfo.builder().fieldName(field.getName()).name(name).order(exportField.index()).build();
        }
        return null;
    }

    @Override
    public void export(ExportContext exportContext, List<?> data, OutputStream outputStream) throws IOException {
        if (data == null) {
            data = Collections.emptyList();
        }
        ExcelWriterBuilder excelWriterBuilder = EasyExcel.write((OutputStream)outputStream, exportContext.getModelClass());
        boolean fillTemplate = StringUtil.isNotEmpty(exportContext.getTemplate());
        if (fillTemplate) {
            InputStream inputStream;
            String templatePath = exportContext.getExportConfig().getTemplatePath();
            if (templatePath.startsWith("classpath:")) {
                ClassPathResource resource = new ClassPathResource(templatePath.replaceFirst("classpath:", "") + exportContext.getTemplate());
                inputStream = resource.getInputStream();
            } else {
                inputStream = Files.newInputStream(Paths.get(templatePath, new String[0]), new OpenOption[0]);
            }
            excelWriterBuilder = excelWriterBuilder.withTemplate(inputStream);
        }
        if (CollectionUtil.isNotEmpty(exportContext.getFieldInfos())) {
            Set includeColumns = exportContext.getFieldInfos().stream().map(ExportFieldInfo::getFieldName).collect(Collectors.toSet());
            excelWriterBuilder = (ExcelWriterBuilder)excelWriterBuilder.includeColumnFiledNames(includeColumns);
        }
        excelWriterBuilder = excelWriterBuilder.excelType(exportContext.getExcelType());
        if (fillTemplate) {
            this.exportWithTemplate(exportContext, data, excelWriterBuilder);
        } else {
            this.export(exportContext, data, excelWriterBuilder);
        }
    }

    protected void export(ExportContext exportContext, List<?> data, ExcelWriterBuilder excelWriterBuilder) {
        ExcelWriterSheetBuilder excelWriterSheetBuilder = excelWriterBuilder.sheet(StringUtil.firstNotEmpty(exportContext.getSheetName(), exportContext.getExportConfig().getDefaultSheetName()));
        excelWriterSheetBuilder.doWrite(data);
    }

    protected void exportWithTemplate(ExportContext exportContext, List<?> data, ExcelWriterBuilder excelWriterBuilder) {
        ExcelWriter excelWriter = excelWriterBuilder.build();
        List<ExportFillData> exportFillDataList = exportContext.listExportFillData();
        boolean dataFillFlag = CollectionUtil.isNotEmpty(data);
        if (dataFillFlag) {
            for (Object item : data) {
                if (!(item instanceof ExportFillData)) continue;
                exportFillDataList.add((ExportFillData)item);
                dataFillFlag = false;
            }
        }
        MyExcelWriteFillExecutor excelWriteFillExecutor = new MyExcelWriteFillExecutor(excelWriter.writeContext());
        if (dataFillFlag) {
            WriteSheet writeSheet = new ExcelWriterSheetBuilder(excelWriter).sheetName(StringUtil.firstNotEmpty(exportContext.getSheetName(), exportContext.getExportConfig().getDefaultSheetName())).build();
            this.fill(excelWriter.writeContext(), excelWriteFillExecutor, data, null, writeSheet, false);
        }
        for (ExportFillData exportFillData : exportFillDataList) {
            if (exportFillData.isFillAllSheet()) {
                int numberOfSheets = excelWriter.writeContext().writeWorkbookHolder().getWorkbook().getNumberOfSheets();
                for (int sheetNo = 0; sheetNo < numberOfSheets; ++sheetNo) {
                    WriteSheet writeSheet = new ExcelWriterSheetBuilder(excelWriter).sheetNo(Integer.valueOf(sheetNo)).build();
                    this.fill(excelWriter.writeContext(), excelWriteFillExecutor, exportFillData.getData(), exportFillData.getFillConfig(), writeSheet, true);
                }
                continue;
            }
            WriteSheet writeSheet = new ExcelWriterSheetBuilder(excelWriter).sheetNo(exportFillData.getSheetNo()).sheetName(exportFillData.getSheetName()).build();
            this.fill(excelWriter.writeContext(), excelWriteFillExecutor, exportFillData.getData(), exportFillData.getFillConfig(), writeSheet, false);
        }
        if (exportContext.isFormula()) {
            this.doFormula(exportContext, excelWriter.writeContext().writeWorkbookHolder().getWorkbook());
        }
        excelWriter.finish();
    }

    private void doFormula(ExportContext exportContext, Workbook workbook) {
        workbook.setForceFormulaRecalculation(true);
        FormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
        for (int sheetNum = 0; sheetNum < workbook.getNumberOfSheets(); ++sheetNum) {
            Sheet sheet = workbook.getSheetAt(sheetNum);
            for (Row r : sheet) {
                for (Cell c : r) {
                    String cell;
                    if (c == null || c.getCellTypeEnum() != CellType.STRING || !StringUtil.isNotEmpty(cell = c.getStringCellValue())) continue;
                    if (cell.startsWith("=")) {
                        c.setCellFormula(cell.substring(1));
                        evaluator.evaluate(c);
                        continue;
                    }
                    if (!cell.startsWith(exportContext.getExportConfig().getFormulaPrefix())) continue;
                    c.setCellFormula(cell.substring(exportContext.getExportConfig().getFormulaPrefix().length()));
                    evaluator.evaluate(c);
                }
            }
        }
    }

    public void fill(WriteContext context, MyExcelWriteFillExecutor excelWriteFillExecutor, Object data, FillConfig fillConfig, WriteSheet writeSheet, boolean ignoreFillKeyNotFound) {
        try {
            if (context.writeWorkbookHolder().getTempTemplateInputStream() == null) {
                throw new ExcelGenerateException("Calling the 'fill' method must use a template.");
            }
            context.currentSheet(writeSheet, WriteTypeEnum.FILL);
            excelWriteFillExecutor.fill(data, fillConfig);
        }
        catch (FillKeyNotFoundException e) {
            if (!ignoreFillKeyNotFound) {
                context.finish(true);
                throw e;
            }
        }
        catch (RuntimeException e) {
            context.finish(true);
            throw e;
        }
        catch (Exception e) {
            context.finish(true);
            throw new ExcelGenerateException((Throwable)e);
        }
    }

    private EasyExcelProvider() {
    }
}

