/*
 * Decompiled with CFR 0.152.
 */
package com.gongbo.export.advise;

import com.gongbo.export.config.ExportConfig;
import com.gongbo.export.config.ResultHandler;
import com.gongbo.export.core.ExportContextHolder;
import com.gongbo.export.core.ExportHandlers;
import com.gongbo.export.core.ExportHelper;
import com.gongbo.export.core.handler.AfterExportHandler;
import com.gongbo.export.core.handler.ExportDataConvert;
import com.gongbo.export.core.handler.WriteHandler;
import com.gongbo.export.entity.ExportContext;
import com.gongbo.export.entity.ExportInfo;
import com.gongbo.export.entity.ExportParam;
import com.gongbo.export.exception.NotSupportExportException;
import com.gongbo.export.utils.ExportUtils;
import com.gongbo.export.utils.WebUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Aspect
public class ExportAdvise {
    private static final Logger log = LoggerFactory.getLogger(ExportAdvise.class);
    @Autowired
    private ResultHandler resultHandler;
    @Autowired
    private ExportConfig exportConfig;

    @Pointcut(value="@annotation(com.gongbo.export.annotations.AutoExport) || @annotation(com.gongbo.export.annotations.AutoExports)")
    public void doExport() {
    }

    @Around(value="doExport()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        ExportParam exportParam = ExportParam.parse(Objects.requireNonNull(WebUtils.getRequest()));
        if (exportParam == null) {
            return joinPoint.proceed();
        }
        HttpServletResponse response = Objects.requireNonNull(WebUtils.getResponse());
        Method targetMethod = ExportAdvise.getTargetMethod(joinPoint);
        try {
            return this.doExport(exportParam, joinPoint, targetMethod, response);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u9519\u8bef", (Throwable)e);
            return this.buildErrorResponse(e);
        }
    }

    private Object doExport(ExportParam exportParam, ProceedingJoinPoint joinPoint, Method targetMethod, HttpServletResponse response) throws Throwable {
        ExportContext exportContext = ExportHelper.buildExportContext(exportParam, targetMethod, this.exportConfig, this.resultHandler);
        try {
            ExportContextHolder.setContext(exportContext);
            if (exportContext.getExportParam().isInfo()) {
                Object object = this.buildExportInfoResponse(exportContext);
                return object;
            }
            if (exportContext.getExportParam().isExcel()) {
                Object result = joinPoint.proceed();
                if (!this.resultHandler.check(result)) {
                    throw new NotSupportExportException(MessageFormat.format("\u8bf7\u6c42\u63a5\u53e3\u65b9\u6cd5\u8fd4\u56de\u7c7b\u578b\u5fc5\u987b\u662f{0}\u7c7b\u578b", this.exportConfig.getResponseClassName()));
                }
                Object object = ExportAdvise.responseExcel(exportContext, result, response);
                return object;
            }
            throw new IllegalArgumentException();
        }
        finally {
            ExportContextHolder.clear();
        }
    }

    private Object buildExportInfoResponse(ExportContext exportContext) {
        ExportInfo exportInfo = ExportInfo.buildExportInfo(exportContext);
        return this.resultHandler.success(exportInfo);
    }

    private Object buildErrorResponse(Exception e) {
        return this.resultHandler.error(e);
    }

    private static Object responseExcel(ExportContext exportContext, Object result, HttpServletResponse response) throws IOException {
        ExportDataConvert exportDataConvert = ExportHandlers.of(exportContext.getAutoExport().dataConvert());
        List<?> data = exportDataConvert.convert(exportContext, result);
        WriteHandler writeHandler = ExportHandlers.of(exportContext.getAutoExport().writeHandler());
        writeHandler.write(exportContext, data, ExportUtils.getExportOutputStream(exportContext, response));
        AfterExportHandler afterExportHandler = ExportHandlers.of(exportContext.getAutoExport().afterExportHandler());
        afterExportHandler.afterExport(exportContext);
        return exportContext.isOutputFile() ? result : null;
    }

    private static Method getTargetMethod(ProceedingJoinPoint proceedingJoinPoint) {
        return ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
    }
}

