/*
 * Decompiled with CFR 0.152.
 */
package com.gongbo.export.entity;

import com.alibaba.excel.support.ExcelTypeEnum;
import com.gongbo.export.annotations.AutoExport;
import com.gongbo.export.config.ExportConfig;
import com.gongbo.export.config.ResultHandler;
import com.gongbo.export.entity.ExportFieldInfo;
import com.gongbo.export.entity.ExportParam;
import com.gongbo.export.entity.fill.ExportFillData;
import com.gongbo.export.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExportContext {
    private ExportParam exportParam;
    private AutoExport autoExport;
    private Class<?> modelClass;
    private String fileName;
    private String sheetName;
    private String template;
    private ExcelTypeEnum excelType;
    private String outputPath;
    private boolean formula;
    private List<ExportFieldInfo> fieldInfos;
    private Map<Object, Object> userContext;
    private ExportConfig exportConfig;
    private ResultHandler resultHandler;

    public boolean isOutputFile() {
        return StringUtil.isNotEmpty(this.outputPath);
    }

    public void addExportFillData(ExportFillData exportFillData) {
        this.listExportFillData().add(exportFillData);
    }

    public List<ExportFillData> listExportFillData() {
        return (List)this.userContext.computeIfAbsent(this.exportConfig.getFillKey(), _ignored -> new ArrayList());
    }

    public static ExportContextBuilder builder() {
        return new ExportContextBuilder();
    }

    public ExportParam getExportParam() {
        return this.exportParam;
    }

    public AutoExport getAutoExport() {
        return this.autoExport;
    }

    public Class<?> getModelClass() {
        return this.modelClass;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public String getTemplate() {
        return this.template;
    }

    public ExcelTypeEnum getExcelType() {
        return this.excelType;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public boolean isFormula() {
        return this.formula;
    }

    public List<ExportFieldInfo> getFieldInfos() {
        return this.fieldInfos;
    }

    public Map<Object, Object> getUserContext() {
        return this.userContext;
    }

    public ExportConfig getExportConfig() {
        return this.exportConfig;
    }

    public ResultHandler getResultHandler() {
        return this.resultHandler;
    }

    public void setExportParam(ExportParam exportParam) {
        this.exportParam = exportParam;
    }

    public void setAutoExport(AutoExport autoExport) {
        this.autoExport = autoExport;
    }

    public void setModelClass(Class<?> modelClass) {
        this.modelClass = modelClass;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setExcelType(ExcelTypeEnum excelType) {
        this.excelType = excelType;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public void setFormula(boolean formula) {
        this.formula = formula;
    }

    public void setFieldInfos(List<ExportFieldInfo> fieldInfos) {
        this.fieldInfos = fieldInfos;
    }

    public void setUserContext(Map<Object, Object> userContext) {
        this.userContext = userContext;
    }

    public void setExportConfig(ExportConfig exportConfig) {
        this.exportConfig = exportConfig;
    }

    public void setResultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    public ExportContext() {
    }

    public ExportContext(ExportParam exportParam, AutoExport autoExport, Class<?> modelClass, String fileName, String sheetName, String template, ExcelTypeEnum excelType, String outputPath, boolean formula, List<ExportFieldInfo> fieldInfos, Map<Object, Object> userContext, ExportConfig exportConfig, ResultHandler resultHandler) {
        this.exportParam = exportParam;
        this.autoExport = autoExport;
        this.modelClass = modelClass;
        this.fileName = fileName;
        this.sheetName = sheetName;
        this.template = template;
        this.excelType = excelType;
        this.outputPath = outputPath;
        this.formula = formula;
        this.fieldInfos = fieldInfos;
        this.userContext = userContext;
        this.exportConfig = exportConfig;
        this.resultHandler = resultHandler;
    }

    public static class ExportContextBuilder {
        private ExportParam exportParam;
        private AutoExport autoExport;
        private Class<?> modelClass;
        private String fileName;
        private String sheetName;
        private String template;
        private ExcelTypeEnum excelType;
        private String outputPath;
        private boolean formula;
        private List<ExportFieldInfo> fieldInfos;
        private Map<Object, Object> userContext;
        private ExportConfig exportConfig;
        private ResultHandler resultHandler;

        ExportContextBuilder() {
        }

        public ExportContextBuilder exportParam(ExportParam exportParam) {
            this.exportParam = exportParam;
            return this;
        }

        public ExportContextBuilder autoExport(AutoExport autoExport) {
            this.autoExport = autoExport;
            return this;
        }

        public ExportContextBuilder modelClass(Class<?> modelClass) {
            this.modelClass = modelClass;
            return this;
        }

        public ExportContextBuilder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public ExportContextBuilder sheetName(String sheetName) {
            this.sheetName = sheetName;
            return this;
        }

        public ExportContextBuilder template(String template) {
            this.template = template;
            return this;
        }

        public ExportContextBuilder excelType(ExcelTypeEnum excelType) {
            this.excelType = excelType;
            return this;
        }

        public ExportContextBuilder outputPath(String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        public ExportContextBuilder formula(boolean formula) {
            this.formula = formula;
            return this;
        }

        public ExportContextBuilder fieldInfos(List<ExportFieldInfo> fieldInfos) {
            this.fieldInfos = fieldInfos;
            return this;
        }

        public ExportContextBuilder userContext(Map<Object, Object> userContext) {
            this.userContext = userContext;
            return this;
        }

        public ExportContextBuilder exportConfig(ExportConfig exportConfig) {
            this.exportConfig = exportConfig;
            return this;
        }

        public ExportContextBuilder resultHandler(ResultHandler resultHandler) {
            this.resultHandler = resultHandler;
            return this;
        }

        public ExportContext build() {
            return new ExportContext(this.exportParam, this.autoExport, this.modelClass, this.fileName, this.sheetName, this.template, this.excelType, this.outputPath, this.formula, this.fieldInfos, this.userContext, this.exportConfig, this.resultHandler);
        }

        public String toString() {
            return "ExportContext.ExportContextBuilder(exportParam=" + this.exportParam + ", autoExport=" + this.autoExport + ", modelClass=" + this.modelClass + ", fileName=" + this.fileName + ", sheetName=" + this.sheetName + ", template=" + this.template + ", excelType=" + this.excelType + ", outputPath=" + this.outputPath + ", formula=" + this.formula + ", fieldInfos=" + this.fieldInfos + ", userContext=" + this.userContext + ", exportConfig=" + this.exportConfig + ", resultHandler=" + this.resultHandler + ")";
        }
    }
}

