package com.gongbo.export.config;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Getter
@Setter
@ToString
@Component
@ConfigurationProperties(value = "auto-export", ignoreInvalidFields = true)
public class ExportConfig {
    /**
     *
     */
    private String responseClassName;

    /**
     * 默认Sheet名称
     */
    private String defaultSheetName = "Sheet1";

    /**
     * 填充key名
     */
    private String fillKey = "fill_data";

    /**
     * 模板文件路径
     */
    private String templatePath = "classpath:exportTemplates/";

    /**
     * 公式开始前缀
     */
    private String formulaPrefix = "#formula";
}
