package com.gongbo.export.annotations;


import com.alibaba.excel.support.ExcelTypeEnum;
import com.gongbo.export.core.ExportHandlers;
import com.gongbo.export.core.handler.*;
import com.gongbo.export.core.handler.defaults.*;

import java.lang.annotation.*;

@Repeatable(AutoExports.class)
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface AutoExport {

    /**
     * 导出文件名,否则为时间戳
     */
    String fileName() default "";

    /**
     * 导出sheet名称,为空时默认为Sheet1
     */
    String sheetName() default "";

    /**
     * 导出模板文件名称
     */
    String template() default "";

    /**
     * 导出分组，同一个接口支持多种导出时，可以根据前端请求参数中的export_tag匹配对应的导出注解配置
     */
    String tag() default "";

    /**
     * 导出模型类
     * 值为Object.class（默认）时代表根据方法返回类型查找（要求该方法返回类型为ResponseEntity<Collection<T>> / 或 ResponseEntity<T[]>）
     * 值为EnableExport。NoneModel.class时代表没有模型类，注意这时导出方式不能为AUTO
     * 值为其他时代表指定为该模型类
     */
    Class<?> modelClass() default Object.class;

    /**
     * 输出文件地址.这时excel将输出到指定目录，且不会通过http响应
     */
    String outputPath() default "";

    /**
     * 动态名称，优先级大于fileName
     */
    Class<? extends FileNameConvert> fileNameConvert() default DefaultFileNameConvert.class;

    /**
     * 字段过滤
     */
    Class<? extends FieldFilter> fieldFilter() default DefaultFieldFilter.class;

    /**
     * 数据转换
     */
    Class<? extends ExportDataConvert> dataConvert() default DefaultExportDataConvert.class;

    /**
     * 生成文件执行器
     */
    Class<? extends WriteHandler> writeHandler() default DefaultWriteHandler.class;

    /**
     *
     */
    Class<? extends AfterExportHandler> afterExportHandler() default DefaultAfterExportHandler.class;

    /**
     * excel文件格式
     */
    ExcelTypeEnum excelType() default ExcelTypeEnum.XLSX;

    /**
     * 是否执行公式
     */
    boolean formula() default true;

    /**
     * 没有模型类
     */
    final class NoneModel {
    }
}