/*
 * Decompiled with CFR 0.152.
 */
package io.github.goldfish07.reschiper.plugin.utils;

import io.github.goldfish07.reschiper.plugin.operations.FileOperation;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class Utils {
    public static boolean isPresent(String str) {
        return str != null && !str.isEmpty();
    }

    public static boolean isBlank(String str) {
        return !Utils.isPresent(str);
    }

    public static boolean isPresent(Iterator<Boolean> iterator) {
        return iterator != null && iterator.hasNext();
    }

    public static boolean isBlank(Iterator<Boolean> iterator) {
        return !Utils.isPresent(iterator);
    }

    public static String convertToPatternString(String input) {
        String[] searchList = new String[]{".", "?", "*", "+"};
        String[] replacementList = new String[]{"\\.", ".?", ".*", ".+"};
        return Utils.replaceEach(input, searchList, replacementList);
    }

    public static boolean match(String str, HashSet<Pattern> patterns) {
        if (patterns == null) {
            return true;
        }
        for (Pattern p : patterns) {
            boolean isMatch = p.matcher(str).matches();
            if (!isMatch) continue;
            return false;
        }
        return true;
    }

    public static void cleanDir(@NotNull File dir) {
        if (dir.exists()) {
            FileOperation.deleteDir(dir);
            dir.mkdirs();
        }
    }

    public static String readInputStream(@NotNull InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString(StandardCharsets.UTF_8);
    }

    public static String runCmd(String ... cmd) throws IOException, InterruptedException {
        String output;
        Process process = null;
        try {
            process = new ProcessBuilder(cmd).start();
            output = Utils.readInputStream(process.getInputStream());
            process.waitFor();
            if (process.exitValue() != 0) {
                System.err.printf("%s Failed! Please check your signature file.\n%n", cmd[0]);
                throw new RuntimeException(Utils.readInputStream(process.getErrorStream()));
            }
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return output;
    }

    public static String runExec(String[] argv) throws IOException, InterruptedException {
        String output;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(argv);
            output = Utils.readInputStream(process.getInputStream());
            process.waitFor();
            if (process.exitValue() != 0) {
                System.err.printf("%s Failed! Please check your signature file.\n%n", argv[0]);
                throw new RuntimeException(Utils.readInputStream(process.getErrorStream()));
            }
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return output;
    }

    private static void processOutputStreamInThread(@NotNull Process process) throws IOException {
        InputStreamReader ir = new InputStreamReader(process.getInputStream());
        LineNumberReader input = new LineNumberReader(ir);
        while (input.readLine() != null) {
        }
    }

    private static String replaceEach(String text, String[] searchList, String[] replacementList) {
        String pattern;
        int textIndex;
        SearchTracker tracker = new SearchTracker(text, searchList, replacementList);
        if (!tracker.hasNextMatch(0)) {
            return text;
        }
        StringBuilder buf = new StringBuilder(text.length() * 2);
        int start = 0;
        do {
            SearchTracker.MatchInfo matchInfo = tracker.matchInfo;
            textIndex = matchInfo.textIndex;
            pattern = matchInfo.pattern;
            String replacement = matchInfo.replacement;
            buf.append(text, start, textIndex);
            buf.append(replacement);
        } while (tracker.hasNextMatch(start = textIndex + pattern.length()));
        return buf.append(text.substring(start)).toString();
    }

    static class SearchTracker {
        final String text;
        final Map<String, String> patternToReplacement = new HashMap<String, String>();
        final Set<String> pendingPatterns = new HashSet<String>();
        MatchInfo matchInfo = null;

        SearchTracker(String text, String @NotNull [] searchList, String[] replacementList) {
            this.text = text;
            for (int i = 0; i < searchList.length; ++i) {
                String pattern = searchList[i];
                this.patternToReplacement.put(pattern, replacementList[i]);
                this.pendingPatterns.add(pattern);
            }
        }

        boolean hasNextMatch(int start) {
            int textIndex = -1;
            String nextPattern = null;
            for (String pattern : new ArrayList<String>(this.pendingPatterns)) {
                int matchIndex = this.text.indexOf(pattern, start);
                if (matchIndex == -1) {
                    this.pendingPatterns.remove(pattern);
                    continue;
                }
                if (textIndex != -1 && matchIndex >= textIndex) continue;
                textIndex = matchIndex;
                nextPattern = pattern;
            }
            if (nextPattern != null) {
                this.matchInfo = new MatchInfo(nextPattern, this.patternToReplacement.get(nextPattern), textIndex);
                return true;
            }
            return false;
        }

        private record MatchInfo(String pattern, String replacement, int textIndex) {
        }
    }
}

