/*
 * Decompiled with CFR 0.152.
 */
package io.github.goldfish07.reschiper.plugin.obfuscation;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ResourceTableEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.ResourcesUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSource;
import io.github.goldfish07.reschiper.plugin.bundle.AppBundleUtils;
import io.github.goldfish07.reschiper.plugin.bundle.ResourceMapping;
import io.github.goldfish07.reschiper.plugin.bundle.ResourceTableBuilder;
import io.github.goldfish07.reschiper.plugin.obfuscation.StringObfuscator;
import io.github.goldfish07.reschiper.plugin.operations.FileOperation;
import io.github.goldfish07.reschiper.plugin.operations.ResourceTableOperation;
import io.github.goldfish07.reschiper.plugin.parser.ResourcesMappingParser;
import io.github.goldfish07.reschiper.plugin.utils.TimeClock;
import io.github.goldfish07.reschiper.plugin.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourcesObfuscator {
    public static final String RESOURCE_ANDROID_PREFIX = "android:";
    public static final String FILE_MAPPING_NAME = "resources-mapping.txt";
    private static final Logger logger = Logger.getLogger(ResourcesObfuscator.class.getName());
    private final AppBundle rawAppBundle;
    private final Set<String> whiteListRules;
    private final Path outputMappingPath;
    private final ZipFile bundleZipFile;
    private final ResourceMapping resourceMapping;
    MODE mode;

    public MODE getMode(String mode) {
        if (Objects.equals(mode, "dir")) {
            return MODE.DIR;
        }
        if (Objects.equals(mode, "file")) {
            return MODE.FILES;
        }
        return MODE.DEFAULT;
    }

    public ResourcesObfuscator(Path bundlePath, AppBundle rawAppBundle, Set<String> whiteListRules, Path outputLogLocationDir, Path mappingPath) throws IOException {
        this.resourceMapping = mappingPath != null && mappingPath.toFile().exists() ? new ResourcesMappingParser(mappingPath).parse() : new ResourceMapping();
        this.bundleZipFile = new ZipFile(bundlePath.toFile());
        this.outputMappingPath = new File(outputLogLocationDir.toFile(), FILE_MAPPING_NAME).toPath();
        if (Files.exists(this.outputMappingPath, new LinkOption[0])) {
            logger.warning(" Mapping File Cleanup:\n- Deleted existing mapping file: " + this.outputMappingPath);
            Files.delete(this.outputMappingPath);
        }
        this.rawAppBundle = rawAppBundle;
        this.whiteListRules = whiteListRules;
    }

    public void withMode(MODE mode) {
        this.mode = mode;
    }

    public AppBundle obfuscate() throws IOException {
        System.out.println("----------------------------------------\n Resource Obfuscation:\n----------------------------------------\n- Obfuscating resources...");
        TimeClock timeClock = new TimeClock();
        this.checkResMappingRules();
        HashMap<BundleModuleName, BundleModule> obfuscatedModules = new HashMap<BundleModuleName, BundleModule>();
        Map<String, Set<String>> typeEntryMapping = this.generateObfuscatedEntryFilesFromMapping();
        for (Map.Entry entry : this.rawAppBundle.getModules().entrySet()) {
            BundleModule bundleModule = (BundleModule)entry.getValue();
            BundleModuleName bundleModuleName = (BundleModuleName)entry.getKey();
            this.generateResourceMappingRule(bundleModule, typeEntryMapping);
            Map<String, String> obfuscateModuleEntriesMap = this.obfuscateModuleEntries(bundleModule, typeEntryMapping);
            BundleModule obfuscatedModule = this.obfuscateBundleModule(bundleModule, obfuscateModuleEntriesMap);
            obfuscatedModules.put(bundleModuleName, obfuscatedModule);
        }
        AppBundle appBundle = this.rawAppBundle.toBuilder().setModules(ImmutableMap.copyOf(obfuscatedModules)).build();
        System.out.printf("- Obfuscation completed in %s%n\n", timeClock.getElapsedTime());
        this.resourceMapping.writeMappingToFile(this.outputMappingPath);
        return appBundle;
    }

    @NotNull
    private Map<String, Set<String>> generateObfuscatedEntryFilesFromMapping() {
        Set<String> entryList;
        HashMap<String, Set<String>> typeEntryMapping = new HashMap<String, Set<String>>();
        for (String path : this.resourceMapping.getEntryFilesMapping().values()) {
            String parentPath = FileOperation.getParentFromZipFilePath(path);
            String name = FileOperation.getFilePrefixByFileName(FileOperation.getNameFromZipFilePath(path));
            entryList = (HashSet<String>)typeEntryMapping.get(parentPath);
            if (entryList == null) {
                entryList = new HashSet<String>();
            }
            entryList.add(name);
            typeEntryMapping.put(parentPath, entryList);
        }
        for (String entry : this.resourceMapping.getResourceMapping().values()) {
            String name = AppBundleUtils.getEntryNameByResourceName(entry);
            String type = AppBundleUtils.getTypeNameByResourceName(entry);
            entryList = (Set)typeEntryMapping.get(type);
            if (entryList == null) {
                entryList = new HashSet();
            }
            entryList.add(name);
            typeEntryMapping.put(type, entryList);
        }
        return typeEntryMapping;
    }

    private void generateResourceMappingRule(@NotNull BundleModule bundleModule, Map<String, Set<String>> typeEntryMapping) {
        if (bundleModule.getResourceTable().isEmpty()) {
            return;
        }
        StringObfuscator stringObfuscator = new StringObfuscator();
        stringObfuscator.reset(null);
        Resources.ResourceTable table = (Resources.ResourceTable)bundleModule.getResourceTable().get();
        ResourcesUtils.getAllFileReferences((Resources.ResourceTable)table).stream().map(ZipPath::getParent).filter(Objects::nonNull).filter(path -> !this.resourceMapping.getDirMapping().containsKey(path.toString())).forEach(path -> {
            stringObfuscator.reset(null);
            String name = stringObfuscator.getReplaceString(this.resourceMapping.getPathMappingNameList());
            if (this.mode == MODE.FILES || this.isDirectoryInWhiteList(path.toString())) {
                if (this.isDirectoryInWhiteList(path.toString())) {
                    System.out.println(" - [whitelist][dir] " + path);
                }
                this.resourceMapping.putDirMapping(path.toString(), path.toString());
            } else {
                this.resourceMapping.putDirMapping(path.toString(), BundleModule.RESOURCES_DIRECTORY + "/" + name);
            }
        });
        ResourcesUtils.entries((Resources.ResourceTable)table).forEach(entry -> {
            String resourceId = entry.getResourceId().toString();
            String resourceName = AppBundleUtils.getResourceFullName(entry);
            HashSet<String> obfuscationList = (HashSet<String>)typeEntryMapping.get(entry.getType().getName());
            if (obfuscationList == null) {
                obfuscationList = new HashSet<String>();
            }
            stringObfuscator.reset(null);
            if (this.resourceMapping.getResourceMapping().containsKey(resourceName)) {
                if (this.isResourceInWhiteList(resourceName)) {
                    System.out.printf(" removing from mapping: %s, id: %s%n", resourceName, resourceId);
                    this.resourceMapping.getResourceMapping().remove(resourceName);
                } else {
                    String obfuscateResourceName = this.resourceMapping.getResourceMapping().get(resourceName);
                    obfuscationList.add(AppBundleUtils.getEntryNameByResourceName(obfuscateResourceName));
                }
            } else if (this.isResourceInWhiteList(resourceName)) {
                System.out.printf(" - [whitelist][resource] %s, id: %s%n", resourceName, resourceId);
            } else {
                String name = stringObfuscator.getReplaceString(obfuscationList);
                obfuscationList.add(name);
                String obfuscatedResourceName = AppBundleUtils.getResourceFullName(entry.getPackage().getPackageName(), entry.getType().getName(), name);
                this.resourceMapping.putResourceMapping(resourceName, obfuscatedResourceName);
            }
            typeEntryMapping.put(entry.getType().getName(), obfuscationList);
        });
    }

    @NotNull
    private Map<String, String> obfuscateModuleEntries(@NotNull BundleModule bundleModule, Map<String, Set<String>> typeMappingMap) {
        StringObfuscator guardStringBuilder = new StringObfuscator();
        guardStringBuilder.reset(null);
        HashMap<String, String> obfuscateEntries = new HashMap<String, String>();
        bundleModule.getEntries().stream().filter(entry -> entry.getPath().startsWith(BundleModule.RESOURCES_DIRECTORY)).forEach(entry -> {
            guardStringBuilder.reset(null);
            String entryDir = entry.getPath().getParent().toString();
            String obfuscateDir = this.resourceMapping.getDirMapping().get(entryDir);
            if (obfuscateDir == null) {
                throw new RuntimeException(String.format("can not find resource directory: %s", entryDir));
            }
            HashSet<String> mapping = (HashSet<String>)typeMappingMap.get(obfuscateDir);
            if (mapping == null) {
                mapping = new HashSet<String>();
            }
            String bundleRawPath = bundleModule.getName().getName() + "/" + entry.getPath().toString();
            Object bundleObfuscatedPath = this.resourceMapping.getEntryFilesMapping().get(bundleRawPath);
            if (bundleObfuscatedPath == null) {
                String obfuscatedName;
                String fileSuffix;
                if (this.isResourceInWhiteList(bundleRawPath)) {
                    System.out.printf(" Found whiteList resource file, resource: %s%n", bundleRawPath);
                    return;
                }
                if (this.isFileInWhiteList(entry.getPath().toString())) {
                    fileSuffix = "";
                    obfuscatedName = FileOperation.getFileSimpleName(entry.getPath());
                    System.out.println(" - [whitelist][file] " + entry.getPath().toString());
                } else if (this.mode == MODE.FILES || this.mode == MODE.DEFAULT) {
                    fileSuffix = FileOperation.getFileSuffix(entry.getPath());
                    obfuscatedName = guardStringBuilder.getReplaceString(mapping);
                } else {
                    fileSuffix = "";
                    obfuscatedName = FileOperation.getFileSimpleName(entry.getPath());
                }
                mapping.add(obfuscatedName);
                bundleObfuscatedPath = obfuscateDir + "/" + obfuscatedName + fileSuffix;
                this.resourceMapping.putEntryFileMapping(bundleRawPath, (String)bundleObfuscatedPath);
            }
            if (obfuscateEntries.containsValue(bundleObfuscatedPath)) {
                throw new IllegalArgumentException(String.format("Multiple entries with same key: %s -> %s", bundleRawPath, bundleObfuscatedPath));
            }
            obfuscateEntries.put(bundleRawPath, (String)bundleObfuscatedPath);
            typeMappingMap.put(obfuscateDir, mapping);
        });
        return obfuscateEntries;
    }

    private BundleModule obfuscateBundleModule(@NotNull BundleModule bundleModule, Map<String, String> obfuscatedEntryMap) throws IOException {
        BundleModule.Builder builder = bundleModule.toBuilder();
        ArrayList<ModuleEntry> obfuscateEntries = new ArrayList<ModuleEntry>();
        for (ModuleEntry entry : bundleModule.getEntries()) {
            String bundleRawPath = bundleModule.getName().getName() + "/" + entry.getPath().toString();
            String obfuscatedPath = obfuscatedEntryMap.get(bundleRawPath);
            if (obfuscatedPath != null) {
                ModuleEntry obfuscatedEntry = ModuleEntry.builder().setPath(ZipPath.create((String)obfuscatedPath)).setContent(ByteSource.wrap((byte[])AppBundleUtils.readByte(this.bundleZipFile, entry, bundleModule))).build();
                obfuscateEntries.add(obfuscatedEntry);
                continue;
            }
            obfuscateEntries.add(entry);
        }
        builder.setRawEntries(obfuscateEntries);
        Resources.ResourceTable obfuscatedResTable = this.obfuscateResourceTable(bundleModule, obfuscatedEntryMap);
        if (obfuscatedResTable != null) {
            builder.setResourceTable(obfuscatedResTable);
        }
        return builder.build();
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Resources.ResourceTable obfuscateResourceTable(@NotNull BundleModule bundleModule, Map<String, String> obfuscatedEntryMap) {
        if (bundleModule.getResourceTable().isEmpty()) {
            return null;
        }
        Resources.ResourceTable resourceTable = (Resources.ResourceTable)bundleModule.getResourceTable().get();
        ResourceTableBuilder resourceTableBuilder = new ResourceTableBuilder();
        ResourcesUtils.entries((Resources.ResourceTable)resourceTable).map(entry -> {
            List<Resources.ConfigValue> configValues;
            String resourceName = AppBundleUtils.getResourceFullName(entry);
            String resourceId = entry.getResourceId().toString();
            String obfuscatedResName = this.resourceMapping.getResourceMapping().get(resourceName);
            this.resourceMapping.addResourceNameAndId(resourceName, resourceId);
            Resources.Entry obfuscatedEntry = entry.getEntry();
            if (obfuscatedResName != null) {
                String entryName = AppBundleUtils.getEntryNameByResourceName(obfuscatedResName);
                obfuscatedEntry = ResourceTableOperation.updateEntryName(obfuscatedEntry, entryName);
            }
            if (!(configValues = Stream.of(obfuscatedEntry).map(Resources.Entry::getConfigValueList).flatMap(Collection::stream).map(configValue -> {
                if (!configValue.getValue().getItem().hasFile()) {
                    return configValue;
                }
                String rawPath = configValue.getValue().getItem().getFile().getPath();
                String bundleRawPath = bundleModule.getName().getName() + "/" + rawPath;
                String obfuscatedPath = (String)obfuscatedEntryMap.get(bundleRawPath);
                if (obfuscatedPath != null) {
                    this.resourceMapping.addResourcePathAndId(bundleRawPath, resourceId);
                    this.resourceMapping.putEntryFileMapping(bundleRawPath, obfuscatedPath);
                    return ResourceTableOperation.replaceEntryPath(configValue, obfuscatedPath);
                }
                return configValue;
            }).collect(Collectors.toList())).isEmpty()) {
                obfuscatedEntry = ResourceTableOperation.updateEntryConfigValueList(obfuscatedEntry, configValues);
            }
            return ResourceTableEntry.create((Resources.Package)entry.getPackage(), (Resources.Type)entry.getType(), (Resources.Entry)obfuscatedEntry);
        }).forEach(entry -> {
            ResourceTableOperation.checkConfiguration(entry.getEntry());
            resourceTableBuilder.addPackage(entry.getPackage()).addResource(entry.getType(), entry.getEntry());
        });
        return resourceTableBuilder.build();
    }

    private void checkResMappingRules() {
        this.resourceMapping.getDirMapping().values().stream().map(ZipPath::create).forEach(path -> {
            if (!path.startsWith(BundleModule.RESOURCES_DIRECTORY)) {
                throw new IllegalArgumentException(String.format("Module files can be only in pre-defined directories, the mapping obfuscation rule is %s", path));
            }
        });
    }

    private boolean isResourceInWhiteList(@NotNull String resourceName) {
        if (resourceName.startsWith(RESOURCE_ANDROID_PREFIX)) {
            return true;
        }
        for (String rule : this.whiteListRules) {
            Pattern filterPattern = Pattern.compile(Utils.convertToPatternString(rule));
            if (!filterPattern.matcher(resourceName).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean isDirectoryInWhiteList(@NotNull String dir) {
        for (String rule : this.whiteListRules) {
            if (!dir.startsWith(BundleModule.RESOURCES_DIRECTORY + "/") || !rule.equals(dir)) continue;
            return true;
        }
        return false;
    }

    private boolean isFileInWhiteList(@NotNull String entry) {
        String filename = new File(entry).getName();
        String dir = entry.replace("/" + filename, "");
        for (String rule : this.whiteListRules) {
            if (rule.endsWith("/*")) {
                String ruleWithoutWildcard = rule.substring(0, rule.length() - 2);
                if (!dir.startsWith(BundleModule.RESOURCES_DIRECTORY + "/") || !dir.equals(ruleWithoutWildcard)) continue;
                return true;
            }
            if (!entry.startsWith(BundleModule.RESOURCES_DIRECTORY + "/") || !rule.equals(entry)) continue;
            return true;
        }
        return false;
    }

    public static enum MODE {
        DIR,
        FILES,
        DEFAULT;

    }
}

