/*
 * Decompiled with CFR 0.152.
 */
package io.github.goldfish07.reschiper.plugin.internal;

import com.android.build.gradle.api.ApplicationVariant;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Bundle {
    @NotNull
    public static Path getBundleFilePath(Project project, @NotNull ApplicationVariant variant) {
        String flavor = variant.getName();
        return Bundle.getBundleFileForAGP(project, flavor).toPath();
    }

    @Nullable
    public static File getBundleFileForAGP(@NotNull Project project, String flavor) {
        Task finalizeBundleTask = project.getTasks().getByName("sign" + Bundle.capitalize(flavor) + "Bundle");
        Object bundleFile = finalizeBundleTask.property("finalBundleFile");
        try {
            if (bundleFile != null) {
                Object regularFile = bundleFile.getClass().getMethod("get", new Class[0]).invoke(bundleFile, new Object[0]);
                return (File)regularFile.getClass().getMethod("getAsFile", new Class[0]).invoke(regularFile, new Object[0]);
            }
            return null;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static String capitalize(@NotNull String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }
}

