/*
 * Decompiled with CFR 0.152.
 */
package io.github.goldfish07.reschiper.plugin.command.extensions;

import com.android.aapt.Resources;
import com.android.bundle.Config;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleMetadata;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.ResourcesUtils;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.google.common.collect.ImmutableList;
import io.github.goldfish07.reschiper.plugin.bundle.AppBundleUtils;
import io.github.goldfish07.reschiper.plugin.bundle.ResourceTableBuilder;
import io.github.goldfish07.reschiper.plugin.operations.FileOperation;
import io.github.goldfish07.reschiper.plugin.operations.ResourceTableOperation;
import io.github.goldfish07.reschiper.plugin.utils.TimeClock;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;

public class DuplicateResourceMerger {
    private static final Logger logger = Logger.getLogger(DuplicateResourceMerger.class.getName());
    public static final String DUPLICATE_LOGGER_FILE_SUFFIX = "-duplicate.txt";
    private final Path outputLogLocationDir;
    private final ZipFile bundleZipFile;
    private final AppBundle rawAppBundle;
    private final Map<String, ZipPath> md5FileList = new HashMap<String, ZipPath>();
    private final Map<ZipPath, String> duplicatedFileList = new HashMap<ZipPath, String>();
    private int mergeDuplicatedTotalSize = 0;
    private int mergeDuplicatedTotalCount = 0;

    public DuplicateResourceMerger(Path bundlePath, AppBundle appBundle, Path outputLogLocationDir) throws IOException {
        FilePreconditions.checkFileExistsAndReadable((Path)bundlePath);
        this.outputLogLocationDir = outputLogLocationDir;
        this.bundleZipFile = new ZipFile(bundlePath.toFile());
        this.rawAppBundle = appBundle;
    }

    public AppBundle merge() throws IOException {
        TimeClock timeClock = new TimeClock();
        ArrayList<BundleModule> mergedBundleModuleList = new ArrayList<BundleModule>();
        for (Map.Entry moduleEntry : this.rawAppBundle.getModules().entrySet()) {
            mergedBundleModuleList.add(this.mergeBundleModule((BundleModule)moduleEntry.getValue()));
        }
        AppBundle mergedAppBundle = AppBundle.buildFromModules((ImmutableList)((ImmutableList)mergedBundleModuleList.stream().collect(ImmutableList.toImmutableList())), (Config.BundleConfig)this.rawAppBundle.getBundleConfig(), (BundleMetadata)this.rawAppBundle.getBundleMetadata());
        System.out.printf("removed duplicate resources done, took %s\n-----------------------------------------\n Reduce file count: %s\n Reduce file size: %s\n-----------------------------------------%n", timeClock.getElapsedTime(), this.mergeDuplicatedTotalCount, FileOperation.getNetFileSizeDescription(this.mergeDuplicatedTotalSize));
        return mergedAppBundle;
    }

    private BundleModule mergeBundleModule(@NotNull BundleModule bundleModule) throws IOException {
        Resources.ResourceTable table;
        File logFile = new File(this.outputLogLocationDir.toFile(), bundleModule.getName().getName() + DUPLICATE_LOGGER_FILE_SUFFIX);
        if (Files.exists(logFile.toPath(), new LinkOption[0])) {
            System.out.println("Log File Cleanup:");
            logger.warning("- Deleted existing log file: " + logFile.toPath());
            Files.delete(logFile.toPath());
        }
        if ((table = bundleModule.getResourceTable().orElse(Resources.ResourceTable.getDefaultInstance())).getPackageList().isEmpty() || bundleModule.getEntries().isEmpty()) {
            return bundleModule;
        }
        this.md5FileList.clear();
        this.duplicatedFileList.clear();
        ArrayList<ModuleEntry> mergedModuleEntry = new ArrayList<ModuleEntry>();
        for (ModuleEntry entry : bundleModule.getEntries()) {
            if (!entry.getPath().startsWith(BundleModule.RESOURCES_DIRECTORY)) {
                mergedModuleEntry.add(entry);
                continue;
            }
            String md5 = AppBundleUtils.getEntryMd5(this.bundleZipFile, entry, bundleModule);
            if (this.md5FileList.containsKey(md5)) {
                this.duplicatedFileList.put(entry.getPath(), md5);
                continue;
            }
            this.md5FileList.put(md5, entry.getPath());
            mergedModuleEntry.add(entry);
        }
        this.generateDuplicatedLog(logFile, bundleModule);
        Resources.ResourceTable mergedTable = this.mergeResourceTable(table);
        return bundleModule.toBuilder().setResourceTable(mergedTable).setRawEntries(mergedModuleEntry).build();
    }

    private Resources.ResourceTable mergeResourceTable(Resources.ResourceTable resourceTable) {
        ResourceTableBuilder resourceTableBuilder = new ResourceTableBuilder();
        ResourcesUtils.entries((Resources.ResourceTable)resourceTable).forEach(entry -> {
            ResourceTableBuilder.PackageBuilder packageBuilder = resourceTableBuilder.addPackage(entry.getPackage());
            List<Resources.ConfigValue> configValues = this.getDuplicatedMergedConfigValues(entry.getEntry());
            Resources.Entry mergedEntry = ResourceTableOperation.updateEntryConfigValueList(entry.getEntry(), configValues);
            packageBuilder.addResource(entry.getType(), mergedEntry);
        });
        return resourceTableBuilder.build();
    }

    private List<Resources.ConfigValue> getDuplicatedMergedConfigValues(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Resources.Entry entry) {
        return Stream.of(entry.getConfigValueList()).flatMap(Collection::stream).map(configValue -> {
            if (!configValue.getValue().getItem().hasFile()) {
                return configValue;
            }
            ZipPath zipPath = ZipPath.create((String)configValue.getValue().getItem().getFile().getPath());
            if (this.duplicatedFileList.containsKey(zipPath)) {
                zipPath = this.md5FileList.get(this.duplicatedFileList.get(zipPath));
            }
            return ResourceTableOperation.replaceEntryPath(configValue, zipPath.toString());
        }).collect(Collectors.toList());
    }

    private void generateDuplicatedLog(@NotNull File logFile, BundleModule bundleModule) throws IOException {
        int duplicatedSize = 0;
        FilePreconditions.checkFileDoesNotExist((Path)logFile.toPath());
        BufferedWriter writer = new BufferedWriter(new FileWriter(logFile, false));
        writer.write("res filter path mapping:\n");
        ((Writer)writer).flush();
        System.out.println("----------------------------------------");
        System.out.println(" Resource Duplication Detected:");
        System.out.println("----------------------------------------");
        for (Map.Entry<ZipPath, String> entry : this.duplicatedFileList.entrySet()) {
            ModuleEntry moduleEntry = (ModuleEntry)bundleModule.getEntry(entry.getKey()).get();
            long fileSize = AppBundleUtils.getZipEntrySize(this.bundleZipFile, moduleEntry, bundleModule);
            duplicatedSize += (int)fileSize;
        }
        System.out.printf("Found duplicated resources (Count: %d, Total Size: %s):\n%n", this.duplicatedFileList.size(), FileOperation.getNetFileSizeDescription(duplicatedSize));
        duplicatedSize = 0;
        for (Map.Entry<ZipPath, String> entry : this.duplicatedFileList.entrySet()) {
            ZipPath keepPath = this.md5FileList.get(entry.getValue());
            ModuleEntry moduleEntry = (ModuleEntry)bundleModule.getEntry(entry.getKey()).get();
            long fileSize = AppBundleUtils.getZipEntrySize(this.bundleZipFile, moduleEntry, bundleModule);
            System.out.printf("- %s (size %s)%n", entry.getKey().toString(), FileOperation.getNetFileSizeDescription(duplicatedSize += (int)fileSize));
            writer.write("\t" + entry.getKey().toString() + " -> " + keepPath.toString() + " (size " + FileOperation.getNetFileSizeDescription(fileSize) + ")\n");
        }
        writer.write("removed: count(" + this.duplicatedFileList.size() + "), totalSize(" + FileOperation.getNetFileSizeDescription(duplicatedSize) + ")");
        ((Writer)writer).close();
        this.mergeDuplicatedTotalSize += duplicatedSize;
        this.mergeDuplicatedTotalCount += this.duplicatedFileList.size();
    }
}

