/*
 * Decompiled with CFR 0.152.
 */
package io.github.goldfish07.reschiper.plugin.command.extensions;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.google.common.collect.ImmutableMap;
import io.github.goldfish07.reschiper.plugin.bundle.ResourceTableBuilder;
import io.github.goldfish07.reschiper.plugin.utils.TimeClock;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BundleStringFilter {
    private static final String replaceValue = "[value removed]";
    private final AppBundle rawAppBundle;
    private final String unusedStrPath;
    private final Set<String> languageWhiteList;
    private final Set<String> unUsedNameSet = new HashSet<String>(5000);

    public BundleStringFilter(Path bundlePath, AppBundle rawAppBundle, String unusedStrPath, Set<String> languageWhiteList) {
        FilePreconditions.checkFileExistsAndReadable((Path)bundlePath);
        this.rawAppBundle = rawAppBundle;
        this.unusedStrPath = unusedStrPath;
        this.languageWhiteList = languageWhiteList;
    }

    public AppBundle filter() throws IOException {
        TimeClock timeClock = new TimeClock();
        File unusedStrFile = new File(this.unusedStrPath);
        HashMap<BundleModuleName, BundleModule> obfuscatedModules = new HashMap<BundleModuleName, BundleModule>();
        if (unusedStrFile.exists()) {
            this.unUsedNameSet.addAll(Files.readAllLines(Paths.get(this.unusedStrPath, new String[0])));
            System.out.println("unused string : " + this.unUsedNameSet.size());
        }
        if (!this.unUsedNameSet.isEmpty() || !this.languageWhiteList.isEmpty()) {
            for (Map.Entry entry : this.rawAppBundle.getModules().entrySet()) {
                BundleModule bundleModule = (BundleModule)entry.getValue();
                BundleModuleName bundleModuleName = (BundleModuleName)entry.getKey();
                BundleModule obfuscatedModule = this.obfuscateBundleModule(bundleModule);
                obfuscatedModules.put(bundleModuleName, obfuscatedModule);
            }
        } else {
            return this.rawAppBundle;
        }
        AppBundle appBundle = this.rawAppBundle.toBuilder().setModules(ImmutableMap.copyOf(obfuscatedModules)).build();
        System.out.printf("filtering strings completed in %s\n%n", timeClock.getElapsedTime());
        return appBundle;
    }

    private BundleModule obfuscateBundleModule(@NotNull BundleModule bundleModule) {
        BundleModule.Builder builder = bundleModule.toBuilder();
        Resources.ResourceTable obfuscatedResTable = this.obfuscateResourceTable(bundleModule);
        if (obfuscatedResTable != null) {
            builder.setResourceTable(obfuscatedResTable);
        }
        return builder.build();
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Resources.ResourceTable obfuscateResourceTable(@NotNull BundleModule bundleModule) {
        if (bundleModule.getResourceTable().isEmpty()) {
            return null;
        }
        Resources.ResourceTable rawTable = (Resources.ResourceTable)bundleModule.getResourceTable().get();
        ResourceTableBuilder tableBuilder = new ResourceTableBuilder();
        List packageList = rawTable.getPackageList();
        if (packageList.isEmpty()) {
            return tableBuilder.build();
        }
        for (Resources.Package resPackage : packageList) {
            if (resPackage == null) continue;
            ResourceTableBuilder.PackageBuilder packageBuilder = tableBuilder.addPackage(resPackage);
            List typeList = resPackage.getTypeList();
            HashSet languageFilterSet = new HashSet(100);
            ArrayList<String> nameFilterList = new ArrayList<String>(3000);
            for (Resources.Type resType : typeList) {
                if (resType == null) continue;
                List entryList = resType.getEntryList();
                for (Resources.Entry resEntry : entryList) {
                    if (resEntry == null) continue;
                    if (resPackage.getPackageId().getId() == 127 && resType.getName().equals("string") && this.languageWhiteList != null && !this.languageWhiteList.isEmpty()) {
                        List languageValue = resEntry.getConfigValueList().stream().filter(Objects::nonNull).filter(configValue -> {
                            String locale = configValue.getConfig().getLocale();
                            if (this.keepLanguage(locale)) {
                                return true;
                            }
                            languageFilterSet.add(locale);
                            return false;
                        }).collect(Collectors.toList());
                        resEntry = resEntry.toBuilder().clearConfigValue().addAllConfigValue(languageValue).build();
                    }
                    if (resPackage.getPackageId().getId() == 127 && resType.getName().equals("string") && !this.unUsedNameSet.isEmpty() && this.unUsedNameSet.contains(resEntry.getName())) {
                        List proguardConfigValue = resEntry.getConfigValueList().stream().filter(Objects::nonNull).map(configValue -> {
                            Resources.ConfigValue.Builder rcb = configValue.toBuilder();
                            Resources.Value.Builder rvb = rcb.getValueBuilder();
                            Resources.Item.Builder rib = rvb.getItemBuilder();
                            Resources.String.Builder rfb = rib.getStrBuilder();
                            return rcb.setValue(rvb.setItem(rib.setStr(rfb.setValue(replaceValue).build()).build()).build()).build();
                        }).collect(Collectors.toList());
                        nameFilterList.add(resEntry.getName());
                        resEntry = resEntry.toBuilder().clearConfigValue().addAllConfigValue(proguardConfigValue).build();
                    }
                    packageBuilder.addResource(resType, resEntry);
                }
            }
            System.out.println("filtering " + resPackage.getPackageName() + " id:" + resPackage.getPackageId().getId());
            StringBuilder l = new StringBuilder();
            for (String lan : languageFilterSet) {
                l.append("[remove language] : ").append(lan).append("\n");
            }
            System.out.println(l);
            l = new StringBuilder();
            for (String name : nameFilterList) {
                l.append("[delete name] ").append(name).append("\n");
            }
            System.out.println(l);
            System.out.println("-----------");
            packageBuilder.build();
        }
        return tableBuilder.build();
    }

    private boolean keepLanguage(String lan) {
        if (lan == null || lan.equals(" ") || lan.isEmpty()) {
            return true;
        }
        if (lan.contains("-")) {
            int index = lan.indexOf("-");
            if (index != -1) {
                String language = lan.substring(0, index);
                return this.languageWhiteList.contains(language);
            }
        } else {
            return this.languageWhiteList.contains(lan);
        }
        return false;
    }
}

