/*
 * Decompiled with CFR 0.152.
 */
package io.github.goldfish07.reschiper.plugin.command;

import com.android.tools.build.bundletool.flags.Flag;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.google.auto.value.AutoValue;
import io.github.goldfish07.reschiper.plugin.android.JarSigner;
import io.github.goldfish07.reschiper.plugin.bundle.AppBundleAnalyzer;
import io.github.goldfish07.reschiper.plugin.bundle.AppBundlePackager;
import io.github.goldfish07.reschiper.plugin.bundle.AppBundleSigner;
import io.github.goldfish07.reschiper.plugin.command.AutoValue_Command;
import io.github.goldfish07.reschiper.plugin.command.extensions.BundleFileFilter;
import io.github.goldfish07.reschiper.plugin.command.extensions.BundleStringFilter;
import io.github.goldfish07.reschiper.plugin.command.extensions.DuplicateResourceMerger;
import io.github.goldfish07.reschiper.plugin.command.model.DuplicateResMergerCommand;
import io.github.goldfish07.reschiper.plugin.command.model.FileFilterCommand;
import io.github.goldfish07.reschiper.plugin.command.model.ObfuscateBundleCommand;
import io.github.goldfish07.reschiper.plugin.command.model.StringFilterCommand;
import io.github.goldfish07.reschiper.plugin.obfuscation.ResourcesObfuscator;
import io.github.goldfish07.reschiper.plugin.operations.FileOperation;
import io.github.goldfish07.reschiper.plugin.parser.Parser;
import io.github.goldfish07.reschiper.plugin.parser.xml.StringFilterConfig;
import io.github.goldfish07.reschiper.plugin.utils.TimeClock;
import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Optional;
import java.util.logging.Logger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@AutoValue
public abstract class Command {
    public static final Flag<Path> BUNDLE_LOCATION_FLAG = Flag.path((String)"bundle");
    public static final Flag<Path> OUTPUT_FILE_FLAG = Flag.path((String)"output");
    public static final Flag<Path> CONFIG_LOCATION_FLAG = Flag.path((String)"config");
    public static final Flag<String> STORE_PASSWORD_FLAG = Flag.string((String)"storePassword");
    public static final Flag<String> KEY_ALIAS_FLAG = Flag.string((String)"keyAlias");
    public static final Flag<String> KEY_PASSWORD_FLAG = Flag.string((String)"keyPassword");
    static final Flag<Path> MAPPING_FLAG = Flag.path((String)"mapping");
    private static final Logger logger = Logger.getLogger(Command.class.getName());

    @Contract(value=" -> new")
    @NotNull
    public static Builder builder() {
        return new AutoValue_Command.Builder();
    }

    public Path execute(TYPE commandType) throws Exception {
        TimeClock timeClock = new TimeClock();
        AppBundle appBundle = new AppBundleAnalyzer(this.getBundlePath()).analyze();
        String out = "";
        if (commandType == TYPE.OBFUSCATE_BUNDLE) {
            bundleCommand = this.getObfuscateBundleBuilder();
            if (((ObfuscateBundleCommand)bundleCommand).getFilterFile().isPresent() && ((ObfuscateBundleCommand)bundleCommand).getFilterFile().get().booleanValue()) {
                HashSet<String> fileFilterRules = new HashSet();
                if (((ObfuscateBundleCommand)bundleCommand).getFileFilterRules().isPresent()) {
                    fileFilterRules = ((ObfuscateBundleCommand)bundleCommand).getFileFilterRules().get();
                }
                filter = new BundleFileFilter(this.getBundlePath(), appBundle, fileFilterRules);
                appBundle = ((BundleFileFilter)filter).filter();
            }
            if (((ObfuscateBundleCommand)bundleCommand).getRemoveStr().isPresent() && ((ObfuscateBundleCommand)bundleCommand).getRemoveStr().get().booleanValue()) {
                File unusedFile = new File("");
                if (((ObfuscateBundleCommand)bundleCommand).getUnusedStrPath().isPresent()) {
                    File file = new File(((ObfuscateBundleCommand)bundleCommand).getUnusedStrPath().get());
                    if (file.exists()) {
                        unusedFile = file;
                    } else {
                        System.out.println("unused_strings.txt file is not exists!");
                    }
                }
                HashSet<String> languageWhiteList = new HashSet();
                if (((ObfuscateBundleCommand)bundleCommand).getLanguageWhiteList().isPresent()) {
                    languageWhiteList = ((ObfuscateBundleCommand)bundleCommand).getLanguageWhiteList().get();
                }
                BundleStringFilter filter = new BundleStringFilter(this.getBundlePath(), appBundle, unusedFile.getPath(), languageWhiteList);
                appBundle = filter.filter();
            }
            if (((ObfuscateBundleCommand)bundleCommand).getMergeDuplicatedResources().isPresent() && ((ObfuscateBundleCommand)bundleCommand).getMergeDuplicatedResources().get().booleanValue()) {
                DuplicateResourceMerger merger = new DuplicateResourceMerger(this.getBundlePath(), appBundle, this.getOutputPath().getParent());
                appBundle = merger.merge();
            }
            if (((ObfuscateBundleCommand)bundleCommand).getEnableObfuscate().booleanValue()) {
                Path mappingPath = null;
                if (((ObfuscateBundleCommand)bundleCommand).getMappingPath().isPresent()) {
                    mappingPath = ((ObfuscateBundleCommand)bundleCommand).getMappingPath().get();
                }
                ResourcesObfuscator obfuscator = new ResourcesObfuscator(this.getBundlePath(), appBundle, ((ObfuscateBundleCommand)bundleCommand).getWhiteList(), this.getOutputPath().getParent(), mappingPath);
                obfuscator.withMode(obfuscator.getMode(((ObfuscateBundleCommand)bundleCommand).getObfuscationMode() == null ? "default" : ((ObfuscateBundleCommand)bundleCommand).getObfuscationMode()));
                appBundle = obfuscator.obfuscate();
            }
            new AppBundlePackager(appBundle, this.getOutputPath()).execute();
            if (((ObfuscateBundleCommand)bundleCommand).getDisableSign().isEmpty() || !((ObfuscateBundleCommand)bundleCommand).getDisableSign().get().booleanValue()) {
                AppBundleSigner signer = new AppBundleSigner(this.getOutputPath());
                this.getStoreFile().ifPresent(storeFile -> {
                    if (this.getStorePassword().isPresent() && this.getKeyAlias().isPresent() && this.getKeyPassword().isPresent()) {
                        signer.setBundleSignature(new JarSigner.Signature((Path)storeFile, this.getStorePassword().get(), this.getKeyAlias().get(), this.getKeyPassword().get()));
                    }
                });
                signer.execute();
            }
            out = "----------------------------------------\n Bundle Summary:\n----------------------------------------\n- Bundle packing completed in %s\n- Reduced bundle file size: %s, (Original: %s, New: %s)%n";
        } else if (commandType == TYPE.DUPLICATE_RES_MERGE) {
            DuplicateResMergerCommand resMergeCommand = this.getDuplicateResMergeBuilder();
            DuplicateResourceMerger merger = new DuplicateResourceMerger(this.getBundlePath(), appBundle, this.getOutputPath().getParent());
            appBundle = merger.merge();
            new AppBundlePackager(appBundle, this.getOutputPath()).execute();
            if (resMergeCommand.getDisableSign().isPresent() || !resMergeCommand.getDisableSign().get().booleanValue()) {
                AppBundleSigner signer = new AppBundleSigner(this.getOutputPath());
                this.getStoreFile().ifPresent(storeFile -> {
                    if (this.getStorePassword().isPresent() && this.getKeyAlias().isPresent() && this.getKeyPassword().isPresent()) {
                        signer.setBundleSignature(new JarSigner.Signature((Path)storeFile, this.getStorePassword().get(), this.getKeyAlias().get(), this.getKeyPassword().get()));
                    }
                });
                signer.execute();
            }
            out = "duplicate resources done, took %s\n-----------------------------------------\n\tReduced bundle file size: %s, %s -> %s\n-----------------------------------------%n";
        } else if (commandType == TYPE.FILTER_FILE && this.getFileFilterBuilder().isPresent()) {
            FileFilterCommand fileFilterCommand = this.getFileFilterBuilder().get();
            BundleFileFilter filter = new BundleFileFilter(this.getBundlePath(), appBundle, fileFilterCommand.getFileFilterRules());
            AppBundle filteredAppBundle = filter.filter();
            new AppBundlePackager(filteredAppBundle, this.getOutputPath()).execute();
            if (fileFilterCommand.getDisableSign().isPresent() || !fileFilterCommand.getDisableSign().get().booleanValue()) {
                AppBundleSigner signer = new AppBundleSigner(this.getOutputPath());
                this.getStoreFile().ifPresent(storeFile -> {
                    if (this.getStorePassword().isPresent() && this.getKeyAlias().isPresent() && this.getKeyPassword().isPresent()) {
                        signer.setBundleSignature(new JarSigner.Signature((Path)storeFile, this.getStorePassword().get(), this.getKeyAlias().get(), this.getKeyPassword().get()));
                    }
                });
                signer.execute();
            }
            out = "filter bundle files done, took %s\n-----------------------------------------\n\tReduced bundle file size: %s, %s -> %s\n-----------------------------------------%n";
        } else if (commandType == TYPE.FILTER_STRING) {
            bundleCommand = this.getStringFilterBuilder();
            StringFilterConfig config = new Parser.XML(((StringFilterCommand)bundleCommand).getConfigPath().get()).stringFilterParse();
            if (!config.isActive()) {
                throw (CommandExecutionException)CommandExecutionException.builder().withInternalMessage("parser attribute filter#isactive can not be 'false' in %s command", new Object[]{commandType.name()}).build();
            }
            filter = new BundleStringFilter(this.getBundlePath(), appBundle, config.getPath(), config.getLanguageWhiteList());
            AppBundle filteredAppBundle = ((BundleStringFilter)filter).filter();
            new AppBundlePackager(filteredAppBundle, this.getOutputPath()).execute();
            AppBundleSigner signer = new AppBundleSigner(this.getOutputPath());
            this.getStoreFile().ifPresent(storeFile -> {
                if (this.getStorePassword().isPresent() && this.getKeyAlias().isPresent() && this.getKeyPassword().isPresent()) {
                    signer.setBundleSignature(new JarSigner.Signature((Path)storeFile, this.getStorePassword().get(), this.getKeyAlias().get(), this.getKeyPassword().get()));
                }
            });
            signer.execute();
            out = "filter bundle strings done, took %s\n-----------------------------------------\n\tReduced bundle string size: %s, %s -> %s\n-----------------------------------------%n";
        }
        long rawSize = FileOperation.getFileSizes(this.getBundlePath().toFile());
        long filteredSize = FileOperation.getFileSizes(this.getOutputPath().toFile());
        System.out.printf(out, timeClock.getElapsedTime(), FileOperation.getNetFileSizeDescription(rawSize - filteredSize), FileOperation.getNetFileSizeDescription(rawSize), FileOperation.getNetFileSizeDescription(filteredSize));
        return this.getOutputPath();
    }

    public abstract Path getBundlePath();

    public abstract Path getOutputPath();

    public abstract Optional<Path> getStoreFile();

    public abstract Optional<String> getStorePassword();

    public abstract Optional<String> getKeyAlias();

    public abstract Optional<String> getKeyPassword();

    public abstract StringFilterCommand getStringFilterBuilder();

    public abstract Optional<FileFilterCommand> getFileFilterBuilder();

    public abstract ObfuscateBundleCommand getObfuscateBundleBuilder();

    public abstract DuplicateResMergerCommand getDuplicateResMergeBuilder();

    public static enum TYPE {
        FILTER_FILE,
        FILTER_STRING,
        DUPLICATE_RES_MERGE,
        OBFUSCATE_BUNDLE;

    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setBundlePath(Path var1);

        public abstract Builder setOutputPath(Path var1);

        public abstract Builder setStoreFile(Path var1);

        public abstract Builder setStorePassword(String var1);

        public abstract Builder setKeyAlias(String var1);

        public abstract Builder setKeyPassword(String var1);

        public abstract Builder setStringFilterBuilder(StringFilterCommand var1);

        public abstract Builder setFileFilterBuilder(FileFilterCommand var1);

        public abstract Builder setObfuscateBundleBuilder(ObfuscateBundleCommand var1);

        public abstract Builder setDuplicateResMergeBuilder(DuplicateResMergerCommand var1);

        public abstract Command build();

        public Command build(@NotNull Command command, TYPE commandType) {
            FilePreconditions.checkFileExistsAndReadable((Path)command.getBundlePath());
            if (!command.getBundlePath().toFile().getName().endsWith(".aab")) {
                throw (CommandExecutionException)CommandExecutionException.builder().withInternalMessage("Wrong properties: %s must end with '.aab'.", new Object[]{BUNDLE_LOCATION_FLAG}).build();
            }
            if (!command.getOutputPath().toFile().getName().endsWith(".aab")) {
                throw (CommandExecutionException)CommandExecutionException.builder().withInternalMessage("Wrong properties: %s must end with '.aab'.", new Object[]{OUTPUT_FILE_FLAG}).build();
            }
            if (commandType == TYPE.DUPLICATE_RES_MERGE || commandType == TYPE.FILTER_FILE) {
                FilePreconditions.checkFileDoesNotExist((Path)command.getOutputPath());
            } else if (commandType == TYPE.OBFUSCATE_BUNDLE) {
                FilePreconditions.checkFileExistsAndReadable((Path)command.getBundlePath());
                if (command.getOutputPath().toFile().exists()) {
                    command.getOutputPath().toFile().delete();
                }
                if (command.getObfuscateBundleBuilder().getMappingPath().isPresent()) {
                    File file = command.getObfuscateBundleBuilder().getMappingPath().get().toFile();
                    FilePreconditions.checkFileExistsAndReadable((Path)file.toPath());
                    if (!file.getName().endsWith(".txt")) {
                        throw (CommandExecutionException)CommandExecutionException.builder().withInternalMessage("Wrong properties: %s must end with '.txt'.", new Object[]{MAPPING_FLAG}).build();
                    }
                }
            } else if (commandType == TYPE.FILTER_STRING) {
                FilePreconditions.checkFileExistsAndReadable((Path)command.getStringFilterBuilder().getConfigPath().get());
                FilePreconditions.checkFileDoesNotExist((Path)command.getOutputPath());
                if (!command.getStringFilterBuilder().getConfigPath().get().toFile().getName().endsWith(".xml")) {
                    throw (CommandExecutionException)CommandExecutionException.builder().withInternalMessage("Wrong properties: %s must end with '.xml'.", new Object[]{CONFIG_LOCATION_FLAG}).build();
                }
            }
            if (command.getStoreFile().isPresent()) {
                JarSigner.checkFlagPresent(command.getKeyAlias(), KEY_ALIAS_FLAG);
                JarSigner.checkFlagPresent(command.getKeyPassword(), KEY_PASSWORD_FLAG);
                JarSigner.checkFlagPresent(command.getStorePassword(), STORE_PASSWORD_FLAG);
            }
            return command;
        }
    }
}

