/*
 * Decompiled with CFR 0.152.
 */
package io.github.goldfish07.reschiper.plugin.bundle;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ResourceMapping {
    private final Map<String, String> dirMapping = new HashMap<String, String>();
    private final Map<String, String> resourceMapping = new HashMap<String, String>();
    private final Map<String, String> entryFilesMapping = new HashMap<String, String>();
    private final Map<String, String> resourceNameToIdMapping = new HashMap<String, String>();
    private final Map<String, String> resourcePathToIdMapping = new HashMap<String, String>();

    @Contract(pure=true)
    public static String getResourceSimpleName(@NotNull String resourceName) {
        String[] values = resourceName.split("/");
        return values[values.length - 1];
    }

    public Map<String, String> getDirMapping() {
        return this.dirMapping;
    }

    public Map<String, String> getResourceMapping() {
        return this.resourceMapping;
    }

    public Map<String, String> getEntryFilesMapping() {
        return this.entryFilesMapping;
    }

    public void putDirMapping(String rawPath, String obfuscatePath) {
        this.dirMapping.put(rawPath, obfuscatePath);
    }

    public void putResourceMapping(String rawResource, String obfuscateResource) {
        if (this.resourceMapping.containsValue(obfuscateResource)) {
            throw new IllegalArgumentException(String.format("Multiple entries: %s -> %s", rawResource, obfuscateResource));
        }
        this.resourceMapping.put(rawResource, obfuscateResource);
    }

    public void putEntryFileMapping(String rawPath, String obfuscatedPath) {
        this.entryFilesMapping.put(rawPath, obfuscatedPath);
    }

    public List<String> getPathMappingNameList() {
        return this.dirMapping.values().stream().map(value -> {
            String[] values = value.split("/");
            if (value.isEmpty()) {
                return value;
            }
            return values[values.length - 1];
        }).collect(Collectors.toList());
    }

    public void addResourceNameAndId(String name, String id) {
        this.resourceNameToIdMapping.put(name, id);
    }

    public void addResourcePathAndId(String path, String id) {
        this.resourcePathToIdMapping.put(path, id);
    }

    public void writeMappingToFile(@NotNull Path mappingPath) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(mappingPath.toFile(), false));
        writer.write("res dir mapping:\n");
        for (Map.Entry<String, String> entry : this.dirMapping.entrySet()) {
            writer.write(String.format("\t%s -> %s\n", entry.getKey(), entry.getValue()));
        }
        writer.write("\n\n");
        ((Writer)writer).flush();
        writer.write("res id mapping:\n");
        for (Map.Entry<String, String> entry : this.resourceMapping.entrySet()) {
            writer.write(String.format("\t%s : %s -> %s\n", this.resourceNameToIdMapping.get(entry.getKey()), entry.getKey(), entry.getValue()));
        }
        writer.write("\n\n");
        ((Writer)writer).flush();
        writer.write("res entries path mapping:\n");
        for (Map.Entry<String, String> entry : this.entryFilesMapping.entrySet()) {
            writer.write(String.format("\t%s : %s -> %s\n", this.resourcePathToIdMapping.get(entry.getKey()), entry.getKey(), entry.getValue()));
        }
        writer.write("\n\n");
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }
}

