/*
 * Decompiled with CFR 0.152.
 */
package io.github.goldfish07.reschiper.plugin.bundle;

import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ResourceTableEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.ZipUtils;
import io.github.goldfish07.reschiper.plugin.operations.FileOperation;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;

public class AppBundleUtils {
    public static long getZipEntrySize(@NotNull ZipFile bundleZipFile, @NotNull ModuleEntry entry, @NotNull BundleModule bundleModule) {
        String path = String.format("%s/%s", bundleModule.getName().getName(), entry.getPath().toString());
        ZipEntry bundleConfigEntry = bundleZipFile.getEntry(path);
        return FileOperation.getZipPathFileSize(bundleZipFile, bundleConfigEntry);
    }

    public static long getZipEntrySize(@NotNull ZipFile bundleZipFile, @NotNull ZipPath zipPath) {
        String path = zipPath.toString();
        ZipEntry bundleConfigEntry = bundleZipFile.getEntry(path);
        return FileOperation.getZipPathFileSize(bundleZipFile, bundleConfigEntry);
    }

    @NotNull
    public static String getEntryMd5(@NotNull ZipFile bundleZipFile, @NotNull ModuleEntry entry, @NotNull BundleModule bundleModule) {
        String path = String.format("%s/%s", bundleModule.getName().getName(), entry.getPath().toString());
        ZipEntry bundleConfigEntry = bundleZipFile.getEntry(path);
        try {
            byte[] bs = ZipUtils.asByteSource((ZipFile)bundleZipFile, (ZipEntry)bundleConfigEntry).read();
            return AppBundleUtils.bytesToHexString(DigestUtils.md5((byte[])bs));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] readByte(@NotNull ZipFile bundleZipFile, @NotNull ModuleEntry entry, @NotNull BundleModule bundleModule) throws IOException {
        String path = String.format("%s/%s", bundleModule.getName().getName(), entry.getPath().toString());
        ZipEntry bundleConfigEntry = bundleZipFile.getEntry(path);
        return ZipUtils.asByteSource((ZipFile)bundleZipFile, (ZipEntry)bundleConfigEntry).read();
    }

    @NotNull
    public static String bytesToHexString(byte @NotNull [] src) {
        if (src.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(src.length);
        for (byte b : src) {
            int v = b & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static String getEntryNameByResourceName(@NotNull String resourceName) {
        int index = resourceName.indexOf(".R.");
        String value = resourceName.substring(index + 3);
        String[] values = value.replace(".", "/").split("/");
        if (values.length != 2) {
            throw new RuntimeException("Invalid resource format, it should be package.type.entry, yours: " + resourceName);
        }
        return values[values.length - 1];
    }

    public static String getTypeNameByResourceName(@NotNull String resourceName) {
        int index = resourceName.indexOf(".R.");
        String value = resourceName.substring(index + 3);
        String[] values = value.replace(".", "/").split("/");
        if (values.length != 2) {
            throw new RuntimeException("Invalid resource format, it should be package.type.entry, yours: " + resourceName);
        }
        return values[0];
    }

    public static String getResourceFullName(@NotNull ResourceTableEntry entry) {
        return AppBundleUtils.getResourceFullName(entry.getPackage().getPackageName(), entry.getType().getName(), entry.getEntry().getName());
    }

    public static String getResourceFullName(String packageName, String typeName, String entryName) {
        return String.format("%s.R.%s.%s", packageName, typeName, entryName);
    }
}

