/*
 * Decompiled with CFR 0.152.
 */
package io.github.goldfish07.reschiper.plugin.bundle;

import io.github.goldfish07.reschiper.plugin.android.JarSigner;
import io.github.goldfish07.reschiper.plugin.utils.TimeClock;
import java.io.IOException;
import java.nio.file.Path;

public class AppBundleSigner {
    private final Path bundleFile;
    private JarSigner.Signature bundleSignature = JarSigner.Signature.DEBUG_SIGNATURE;

    public AppBundleSigner(Path bundleFile, JarSigner.Signature signature) {
        this.bundleFile = bundleFile;
        this.bundleSignature = signature;
    }

    public AppBundleSigner(Path bundleFile) {
        this.bundleFile = bundleFile;
    }

    public void setBundleSignature(JarSigner.Signature bundleSignature) {
        this.bundleSignature = bundleSignature;
    }

    public void execute() throws IOException, InterruptedException {
        if (this.bundleSignature == null) {
            return;
        }
        System.out.println("----------------------------------------\n Signing:\n----------------------------------------\n- Signing the bundle...");
        TimeClock timeClock = new TimeClock();
        JarSigner.Signature signature = new JarSigner.Signature(this.bundleSignature.storeFile(), this.bundleSignature.storePassword(), this.bundleSignature.keyAlias(), this.bundleSignature.keyPassword());
        new JarSigner().sign(this.bundleFile.toFile(), signature);
        System.out.printf("- Signing completed in %s%n\n", timeClock.getElapsedTime());
    }
}

