/*
 * Decompiled with CFR 0.152.
 */
package io.github.goldfish07.reschiper.plugin.bundle;

import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import io.github.goldfish07.reschiper.plugin.utils.TimeClock;
import java.io.IOException;
import java.nio.file.Path;
import java.util.zip.ZipFile;

public class AppBundleAnalyzer {
    private final Path bundlePath;

    public AppBundleAnalyzer(Path bundlePath) {
        FilePreconditions.checkFileExistsAndReadable((Path)bundlePath);
        this.bundlePath = bundlePath;
    }

    public AppBundle analyze() throws IOException {
        TimeClock timeClock = new TimeClock();
        ZipFile bundleZip = new ZipFile(this.bundlePath.toFile());
        AppBundle appBundle = AppBundle.buildFromZip((ZipFile)bundleZip);
        System.out.printf("Analysis of the bundle file completed, took %s%n", timeClock.getElapsedTime());
        return appBundle;
    }
}

