/*
 * Decompiled with CFR 0.152.
 */
package io.github.goldfish07.reschiper.plugin;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.ApplicationVariant;
import io.github.goldfish07.reschiper.plugin.Extension;
import io.github.goldfish07.reschiper.plugin.internal.AGP;
import io.github.goldfish07.reschiper.plugin.tasks.ResChiperTask;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;

public class ResChiperPlugin
implements Plugin<Project> {
    public void apply(@NotNull Project project) {
        this.checkApplicationPlugin(project);
        AppExtension android = (AppExtension)project.getExtensions().getByName("android");
        project.getExtensions().create("resChiper", Extension.class, new Object[0]);
        project.afterEvaluate(project1 -> android.getApplicationVariants().all(variant -> this.createResChiperTask((Project)project1, (ApplicationVariant)variant)));
    }

    private void createResChiperTask(@NotNull Project project, @NotNull ApplicationVariant variant) {
        String variantName = variant.getName().substring(0, 1).toUpperCase() + variant.getName().substring(1);
        String bundleTaskName = "bundle" + variantName;
        if (project.getTasks().findByName(bundleTaskName) == null) {
            return;
        }
        String taskName = "resChiper" + variantName;
        ResChiperTask resChiperTask = project.getTasks().findByName(taskName) == null ? (ResChiperTask)project.getTasks().create(taskName, ResChiperTask.class) : (ResChiperTask)project.getTasks().getByName(taskName);
        resChiperTask.setVariantScope(variant);
        resChiperTask.doFirst(task -> {
            this.printResChiperBuildConfiguration();
            this.printProjectBuildConfiguration(project);
        });
        Task bundleTask = project.getTasks().getByName(bundleTaskName);
        Task bundlePackageTask = project.getTasks().getByName("package" + variantName + "Bundle");
        bundleTask.dependsOn(new Object[]{resChiperTask});
        resChiperTask.dependsOn(new Object[]{bundlePackageTask});
        String finalizeBundleTaskName = "sign" + variantName + "Bundle";
        if (project.getTasks().findByName(finalizeBundleTaskName) != null) {
            resChiperTask.dependsOn(new Object[]{project.getTasks().getByName(finalizeBundleTaskName)});
        }
    }

    private void checkApplicationPlugin(@NotNull Project project) {
        if (!project.getPlugins().hasPlugin("com.android.application")) {
            throw new GradleException("Android Application plugin 'com.android.application' is required");
        }
    }

    private void printResChiperBuildConfiguration() {
        System.out.println("----------------------------------------");
        System.out.println(" ResChiper Plugin Configuration:");
        System.out.println("----------------------------------------");
        System.out.println("- ResChiper version:\t0.1.0-rc5");
        System.out.println("- BundleTool version:\t1.16.0");
        System.out.println("- AGP version:\t\t8.5.0");
        System.out.println("- Gradle Wrapper:\t8.5");
    }

    private void printProjectBuildConfiguration(@NotNull Project project) {
        System.out.println("----------------------------------------");
        System.out.println(" App Build Information:");
        System.out.println("----------------------------------------");
        System.out.println("- Project name:\t\t\t" + project.getRootProject().getName());
        System.out.println("- AGP version:\t\t\t" + AGP.getAGPVersion(project));
        System.out.println("- Running Gradle version:\t" + project.getGradle().getGradleVersion());
    }
}

