/*
 * Decompiled with CFR 0.152.
 */
package io.github.glytching.junit.extension.watcher;

import io.github.glytching.junit.extension.util.ExtensionUtil;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class WatcherExtension
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    private final Logger logger;

    WatcherExtension() {
        this(Logger.getLogger(WatcherExtension.class.getName()));
    }

    WatcherExtension(Logger logger) {
        this.logger = logger;
    }

    public void beforeTestExecution(ExtensionContext extensionContext) throws Exception {
        Method testMethod = extensionContext.getRequiredTestMethod();
        this.logger.info(String.format("Starting test [%s]", testMethod.getName()));
        ExtensionUtil.getStore(extensionContext, this.getClass()).put((Object)testMethod, (Object)System.currentTimeMillis());
    }

    public void afterTestExecution(ExtensionContext extensionContext) throws Exception {
        Method testMethod = extensionContext.getRequiredTestMethod();
        long start = (Long)ExtensionUtil.getStore(extensionContext, this.getClass()).remove((Object)testMethod, Long.TYPE);
        long duration = System.currentTimeMillis() - start;
        this.logger.info(String.format("Completed test [%s] in %sms", testMethod.getName(), duration));
    }
}

