/*
 * Decompiled with CFR 0.152.
 */
package com.chibde.visualizer;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import com.chibde.BaseVisualizer;

public class SquareBarVisualizer
extends BaseVisualizer {
    private float density = 16.0f;
    private int gap;

    public SquareBarVisualizer(Context context) {
        super(context);
    }

    public SquareBarVisualizer(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public SquareBarVisualizer(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init() {
        this.density = 16.0f;
        this.gap = 2;
        this.paint.setStyle(Paint.Style.FILL);
    }

    public void setDensity(float density) {
        this.density = density;
        if (density > 256.0f) {
            this.density = 256.0f;
        } else if (density < 16.0f) {
            this.density = 16.0f;
        }
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    protected void onDraw(Canvas canvas) {
        if (this.bytes != null) {
            float barWidth = (float)this.getWidth() / this.density;
            float div = (float)this.bytes.length / this.density;
            this.paint.setStrokeWidth(barWidth - (float)this.gap);
            int i = 0;
            while ((float)i < this.density) {
                int count = 0;
                int bytePosition = (int)Math.ceil((float)i * div);
                int top = this.getHeight() + (byte)(Math.abs(this.bytes[bytePosition]) + 128) * this.getHeight() / 128;
                int col = Math.abs(this.getHeight() - top);
                int j = 0;
                while (j < col + 1) {
                    float barX = (float)i * barWidth + barWidth / 2.0f;
                    float y1 = (float)this.getHeight() - (barWidth + (float)this.gap / 2.0f) * (float)count;
                    float y2 = (float)this.getHeight() - (barWidth - (float)this.gap / 2.0f + (barWidth + (float)this.gap / 2.0f) * (float)count);
                    canvas.drawLine(barX, y1, barX, y2, this.paint);
                    ++count;
                    j = (int)((float)j + barWidth);
                }
                ++i;
            }
            super.onDraw(canvas);
        }
    }
}

