/*
 * Decompiled with CFR 0.152.
 */
package com.chibde.visualizer;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import com.chibde.BaseVisualizer;

public class LineVisualizer
extends BaseVisualizer {
    private float[] points;
    private Rect rect = new Rect();
    private float strokeWidth = 0.005f;

    public LineVisualizer(Context context) {
        super(context);
    }

    public LineVisualizer(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public LineVisualizer(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init() {
    }

    public void setStrokeWidth(int strokeWidth) {
        if (strokeWidth > 10) {
            this.strokeWidth = 0.049999997f;
        } else if (strokeWidth < 1) {
            this.strokeWidth = 0.005f;
        }
        this.strokeWidth = (float)strokeWidth * 0.005f;
    }

    protected void onDraw(Canvas canvas) {
        if (this.bytes != null) {
            if (this.points == null || this.points.length < this.bytes.length * 4) {
                this.points = new float[this.bytes.length * 4];
            }
            this.paint.setStrokeWidth((float)this.getHeight() * this.strokeWidth);
            this.rect.set(0, 0, this.getWidth(), this.getHeight());
            for (int i = 0; i < this.bytes.length - 1; ++i) {
                this.points[i * 4] = this.rect.width() * i / (this.bytes.length - 1);
                this.points[i * 4 + 1] = this.rect.height() / 2 + (byte)(this.bytes[i] + 128) * (this.rect.height() / 3) / 128;
                this.points[i * 4 + 2] = this.rect.width() * (i + 1) / (this.bytes.length - 1);
                this.points[i * 4 + 3] = this.rect.height() / 2 + (byte)(this.bytes[i + 1] + 128) * (this.rect.height() / 3) / 128;
            }
            canvas.drawLines(this.points, this.paint);
        }
        super.onDraw(canvas);
    }
}

