/*
 * Decompiled with CFR 0.152.
 */
package com.chibde.visualizer;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import com.chibde.BaseVisualizer;

public class LineBarVisualizer
extends BaseVisualizer {
    private Paint middleLine;
    private float density;
    private int gap;

    public LineBarVisualizer(Context context) {
        super(context);
    }

    public LineBarVisualizer(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public LineBarVisualizer(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init() {
        this.density = 50.0f;
        this.gap = 4;
        this.middleLine = new Paint();
        this.middleLine.setColor(-16776961);
    }

    public void setDensity(float density) {
        if (this.density > 180.0f) {
            this.middleLine.setStrokeWidth(1.0f);
            this.gap = 1;
        } else {
            this.gap = 4;
        }
        this.density = density;
        if (density > 256.0f) {
            this.density = 256.0f;
            this.gap = 0;
        } else if (density <= 10.0f) {
            this.density = 10.0f;
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.middleLine.getColor() != -16776961) {
            this.middleLine.setColor(this.color);
        }
        if (this.bytes != null) {
            float barWidth = (float)this.getWidth() / this.density;
            float div = (float)this.bytes.length / this.density;
            canvas.drawLine(0.0f, (float)(this.getHeight() / 2), (float)this.getWidth(), (float)(this.getHeight() / 2), this.middleLine);
            this.paint.setStrokeWidth(barWidth - (float)this.gap);
            int i = 0;
            while ((float)i < this.density) {
                int bytePosition = (int)Math.ceil((float)i * div);
                int top = this.getHeight() / 2 + (128 - Math.abs(this.bytes[bytePosition])) * (this.getHeight() / 2) / 128;
                int bottom = this.getHeight() / 2 - (128 - Math.abs(this.bytes[bytePosition])) * (this.getHeight() / 2) / 128;
                float barX = (float)i * barWidth + barWidth / 2.0f;
                canvas.drawLine(barX, (float)bottom, barX, (float)(this.getHeight() / 2), this.paint);
                canvas.drawLine(barX, (float)top, barX, (float)(this.getHeight() / 2), this.paint);
                ++i;
            }
            super.onDraw(canvas);
        }
    }
}

