/*
 * Decompiled with CFR 0.152.
 */
package com.chibde.visualizer;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import com.chibde.BaseVisualizer;

public class BarVisualizer
extends BaseVisualizer {
    private float density = 50.0f;
    private int gap;

    public BarVisualizer(Context context) {
        super(context);
    }

    public BarVisualizer(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public BarVisualizer(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init() {
        this.density = 50.0f;
        this.gap = 4;
        this.paint.setStyle(Paint.Style.FILL);
    }

    public void setDensity(float density) {
        this.density = density;
        if (density > 256.0f) {
            this.density = 256.0f;
        } else if (density < 10.0f) {
            this.density = 10.0f;
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.bytes != null) {
            float barWidth = (float)this.getWidth() / this.density;
            float div = (float)this.bytes.length / this.density;
            this.paint.setStrokeWidth(barWidth - (float)this.gap);
            int i = 0;
            while ((float)i < this.density) {
                int bytePosition = (int)Math.ceil((float)i * div);
                int top = this.getHeight() + (byte)(Math.abs(this.bytes[bytePosition]) + 128) * this.getHeight() / 128;
                float barX = (float)i * barWidth + barWidth / 2.0f;
                canvas.drawLine(barX, (float)this.getHeight(), barX, (float)top, this.paint);
                ++i;
            }
            super.onDraw(canvas);
        }
    }
}

