/*
 * Decompiled with CFR 0.152.
 */
package io.github.g00fy2.versioncompare;

import java.util.List;
import org.jetbrains.annotations.NotNull;

final class VersionComparator {
    private static final String SNAPSHOT_STRING = "snapshot";
    private static final String PRE_STRING = "pre";
    private static final String ALPHA_STRING = "alpha";
    private static final String BETA_STRING = "beta";
    private static final String RC_STRING = "rc";

    private VersionComparator() {
    }

    static int compareSubversionNumbers(@NotNull List<Long> versionNumbersA, @NotNull List<Long> versionNumbersB) {
        int numbersSizeA = versionNumbersA.size();
        int numbersSizeB = versionNumbersB.size();
        int maxSize = Math.max(numbersSizeA, numbersSizeB);
        for (int i = 0; i < maxSize; ++i) {
            if ((i < numbersSizeA ? versionNumbersA.get(i) : 0L) > (i < numbersSizeB ? versionNumbersB.get(i) : 0L)) {
                return 1;
            }
            if ((i < numbersSizeA ? versionNumbersA.get(i) : 0L) >= (i < numbersSizeB ? versionNumbersB.get(i) : 0L)) continue;
            return -1;
        }
        return 0;
    }

    static ReleaseType qualifierToReleaseType(@NotNull String suffix) {
        if (suffix.length() > 0) {
            if ((suffix = suffix.toLowerCase()).contains(RC_STRING)) {
                return ReleaseType.RC;
            }
            if (suffix.contains(BETA_STRING)) {
                return ReleaseType.BETA;
            }
            if (suffix.contains(ALPHA_STRING)) {
                if (suffix.substring(0, suffix.indexOf(ALPHA_STRING)).contains(PRE_STRING)) {
                    return ReleaseType.PRE_ALPHA;
                }
                return ReleaseType.ALPHA;
            }
            if (suffix.contains(SNAPSHOT_STRING)) {
                return ReleaseType.SNAPSHOT;
            }
        }
        return ReleaseType.STABLE;
    }

    static long preReleaseVersion(@NotNull String suffix, ReleaseType releaseType) {
        int maxStartIndex;
        if (releaseType == ReleaseType.STABLE || releaseType == ReleaseType.SNAPSHOT) {
            return 0L;
        }
        int startIndex = VersionComparator.indexOfQualifier(suffix, releaseType);
        if (startIndex < suffix.length() && VersionComparator.containsNumeric(suffix.substring(startIndex, maxStartIndex = Math.min(startIndex + 2, suffix.length())))) {
            StringBuilder versionNumber = new StringBuilder();
            for (int i = startIndex; i < suffix.length(); ++i) {
                char c = suffix.charAt(i);
                if (Character.isDigit(c)) {
                    versionNumber.append(c);
                    continue;
                }
                if (i != startIndex) break;
            }
            return VersionComparator.safeParseLong(versionNumber.toString());
        }
        return 0L;
    }

    private static int indexOfQualifier(@NotNull String suffix, ReleaseType releaseType) {
        suffix = suffix.toLowerCase();
        switch (releaseType) {
            case RC: {
                return suffix.indexOf(RC_STRING) + RC_STRING.length();
            }
            case BETA: {
                return suffix.indexOf(BETA_STRING) + BETA_STRING.length();
            }
            case ALPHA: 
            case PRE_ALPHA: {
                return suffix.indexOf(ALPHA_STRING) + ALPHA_STRING.length();
            }
        }
        return 0;
    }

    static boolean startsNumeric(@NotNull String str) {
        return (str = str.trim()).length() > 0 && Character.isDigit(str.charAt(0));
    }

    static long safeParseLong(@NotNull String numbers) {
        if (numbers.length() > 19) {
            numbers = numbers.substring(0, 19);
        }
        return Long.parseLong(numbers);
    }

    static boolean isNumeric(@NotNull CharSequence cs) {
        int sz = cs.length();
        if (sz > 0) {
            for (int i = 0; i < sz; ++i) {
                if (Character.isDigit(cs.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean containsNumeric(@NotNull CharSequence cs) {
        int sz = cs.length();
        if (sz > 0) {
            for (int i = 0; i < sz; ++i) {
                if (!Character.isDigit(cs.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    static enum ReleaseType {
        SNAPSHOT,
        PRE_ALPHA,
        ALPHA,
        BETA,
        RC,
        STABLE;

    }
}

