/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import madkit.i18n.ErrorMessages;
import madkit.i18n.I18nUtilities;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.kernel.CGRNotAvailable;
import madkit.kernel.Gatekeeper;
import madkit.kernel.GroupManagerAddress;
import madkit.kernel.KernelAddress;
import madkit.kernel.MadkitKernel;
import madkit.kernel.ManagerRole;
import madkit.kernel.Message;
import madkit.kernel.MicroAgent;
import madkit.kernel.Organization;
import madkit.kernel.RequestRoleSecure;
import madkit.kernel.Role;
import madkit.message.ObjectMessage;

final class Group
extends ConcurrentHashMap<String, Role> {
    private static final long serialVersionUID = 498214902172237862L;
    private final Gatekeeper gatekeeper;
    private final Logger logger;
    private final String communityName;
    private final String groupName;
    private final Organization communityObject;
    private final boolean isSecured;
    private final boolean distributed;

    Group(String community, String group, AbstractAgent creator, Gatekeeper gatekeeper, boolean isDistributed, Organization organization) {
        this.distributed = isDistributed;
        this.gatekeeper = gatekeeper;
        this.isSecured = gatekeeper != null;
        this.communityName = community;
        this.groupName = group;
        this.communityObject = organization;
        this.logger = this.communityObject.getLogger();
        this.put("manager", new ManagerRole(this, creator, this.isSecured));
    }

    final Organization getCommunityObject() {
        return this.communityObject;
    }

    Group(String community, String group, AgentAddress manager, Organization communityObject) {
        this.distributed = true;
        this.communityObject = communityObject;
        this.logger = communityObject.getLogger();
        this.isSecured = manager instanceof GroupManagerAddress ? ((GroupManagerAddress)manager).isGroupSecured() : false;
        this.gatekeeper = null;
        this.communityName = community;
        this.groupName = group;
        this.put("manager", new ManagerRole(this, manager));
    }

    boolean isSecured() {
        return this.isSecured;
    }

    String getName() {
        return this.groupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractAgent.ReturnCode requestRole(final AbstractAgent requester, final String roleName, final Object memberCard) {
        Objects.requireNonNull(roleName, ErrorMessages.R_NULL.toString());
        if (this.isSecured) {
            final MadkitKernel myKernel = this.getCommunityObject().getMyKernel();
            if (this.gatekeeper == null) {
                final AgentAddress manager = myKernel.getAgentWithRole(this.communityName, this.groupName, "manager");
                final AgentAddress distantAgentWithRole = myKernel.getDistantAgentWithRole(requester, "local", "kernels", "manager", manager.getKernelAddress());
                MicroAgent<Boolean> ma = new MicroAgent<Boolean>(){

                    @Override
                    protected void activate() {
                        super.activate();
                        try {
                            Message m = this.sendMessageAndWaitForReply(distantAgentWithRole, new RequestRoleSecure(myKernel.getSenderAgentAddress(requester, manager, null), roleName, memberCard), 10000);
                            if (m != null) {
                                this.setResult(((ObjectMessage)m).getContent());
                            } else {
                                this.setResult(null);
                            }
                        }
                        catch (CGRNotAvailable e) {
                            e.printStackTrace();
                        }
                    }
                };
                myKernel.launchAgent(ma);
                if (!((Boolean)ma.getResult()).booleanValue()) {
                    return AbstractAgent.ReturnCode.ACCESS_DENIED;
                }
            } else if (!this.gatekeeper.allowAgentToTakeRole(requester.getNetworkID(), roleName, memberCard)) {
                return AbstractAgent.ReturnCode.ACCESS_DENIED;
            }
        }
        Group group = this;
        synchronized (group) {
            Role r = this.getOrCreateRole(roleName);
            if (r.addMember(requester)) {
                r.addToOverlookers(requester);
                return AbstractAgent.ReturnCode.SUCCESS;
            }
            return AbstractAgent.ReturnCode.ROLE_ALREADY_HANDLED;
        }
    }

    Gatekeeper getGatekeeper() {
        return this.gatekeeper;
    }

    Role createRole(String roleName) {
        Role r = new Role(this, roleName);
        this.put(roleName, r);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRole(String roleName) {
        Group group = this;
        synchronized (group) {
            this.remove(roleName);
            if (this.logger != null) {
                this.logger.finer("Removing" + I18nUtilities.getCGRString(this.communityName, this.groupName, roleName));
            }
            this.checkEmptyness();
        }
    }

    private void checkEmptyness() {
        if (this.isEmpty()) {
            this.communityObject.removeGroup(this.groupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Role> leaveGroup(AbstractAgent requester) {
        ArrayList<Role> affectedRoles = null;
        Group group = this;
        synchronized (group) {
            for (Role r : this.values()) {
                if (r.removeMember(requester) != AbstractAgent.ReturnCode.SUCCESS) continue;
                if (affectedRoles == null) {
                    affectedRoles = new ArrayList<Role>(10);
                }
                affectedRoles.add(r);
            }
        }
        return affectedRoles;
    }

    boolean isIn(AbstractAgent agent) {
        return this.values().stream().anyMatch(r -> r.contains(agent));
    }

    AgentAddress getAgentAddressOf(AbstractAgent abstractAgent) {
        for (Role r : this.values()) {
            AgentAddress aa = r.getAgentAddressOf(abstractAgent);
            if (aa == null) continue;
            return aa;
        }
        return null;
    }

    boolean isDistributed() {
        return this.distributed;
    }

    SortedMap<String, Set<AgentAddress>> getGroupMap() {
        TreeMap<String, Set<AgentAddress>> export = new TreeMap<String, Set<AgentAddress>>();
        for (Map.Entry org : this.entrySet()) {
            export.put((String)org.getKey(), ((Role)org.getValue()).buildAndGetAddresses());
        }
        return export;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void importDistantOrg(Map<String, Set<AgentAddress>> map) {
        for (String roleName : map.keySet()) {
            Set<AgentAddress> list = map.get(roleName);
            if (list == null) continue;
            Group group = this;
            synchronized (group) {
                this.getOrCreateRole(roleName).importDistantOrg(list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDistantMember(AgentAddress content) {
        Role r;
        String roleName = content.getRole();
        Group group = this;
        synchronized (group) {
            r = this.getOrCreateRole(roleName);
        }
        r.addDistantMember(content);
    }

    Role getOrCreateRole(String roleName) {
        Role r = (Role)this.get(roleName);
        if (r == null) {
            return this.createRole(roleName);
        }
        return r;
    }

    void removeDistantMember(AgentAddress aa) {
        for (Role r : this.values()) {
            aa.setRoleObject(r);
            r.removeDistantMember(aa);
        }
    }

    void removeAgentsFromDistantKernel(KernelAddress kernelAddress) {
        if (this.logger != null) {
            this.logger.finest("Removing all agents from distant kernel " + kernelAddress + " in" + this);
        }
        for (Role r : this.values()) {
            r.removeAgentsFromDistantKernel(kernelAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void chooseNewManager(AbstractAgent oldManager) {
        Group group = this;
        synchronized (group) {
            if (!this.isEmpty()) {
                for (Role r : this.values()) {
                    for (AbstractAgent a : r.getPlayers()) {
                        if (a == oldManager) continue;
                        this.put("manager", new ManagerRole(this, a, false));
                        return;
                    }
                }
            }
        }
    }

    @Override
    public String toString() {
        return I18nUtilities.getCGRString(this.communityName, this.groupName) + this.values();
    }

    final void destroy() {
        for (Role r : this.values()) {
            r.destroy();
        }
        this.communityObject.removeGroup(this.groupName);
    }
}

