/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import madkit.action.BooleanAction;
import madkit.action.LoggingAction;
import madkit.gui.menu.AgentLogLevelMenu;
import madkit.i18n.Words;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentFormatter;
import madkit.kernel.Madkit;
import madkit.kernel.MadkitProperties;

public final class AgentLogger
extends Logger {
    public static final Formatter AGENT_FORMATTER = new AgentFormatter();
    public static final Formatter AGENT_FILE_FORMATTER = new AgentFormatter(){

        @Override
        protected String getHeader(LogRecord record) {
            return "";
        }
    };
    static final Level TALK = Level.parse("1100");
    private static Map<AbstractAgent, AgentLogger> agentLoggers = new ConcurrentHashMap<AbstractAgent, AgentLogger>();
    private static List<AgentLogger> debugModeBlackList = new ArrayList<AgentLogger>();
    private final AbstractAgent myAgent;
    private BooleanAction agentCGRWarningsOnAction;

    static final AgentLogger getLogger(AbstractAgent agent) {
        return agentLoggers.computeIfAbsent(agent, AgentLogger::new);
    }

    private AgentLogger(AbstractAgent agent) {
        super("[" + agent.getName() + "]", null);
        this.myAgent = agent;
        this.setUseParentHandlers(false);
        MadkitProperties madkitConfig = this.myAgent.getMadkitConfig();
        this.setLevel(Madkit.LevelOption.agentLogLevel.getValue(madkitConfig));
        if (Madkit.BooleanOption.cgrWarnings.isActivated(madkitConfig)) {
            this.enableCGRWarnings();
        }
        if (!Madkit.BooleanOption.noAgentConsoleLog.isActivated(madkitConfig)) {
            ConsoleHandler ch = new ConsoleHandler();
            this.addHandler(ch);
            ch.setFormatter(AGENT_FORMATTER);
        }
        if (Madkit.BooleanOption.createLogFiles.isActivated(madkitConfig) && agent.getMadkitKernel() != agent) {
            this.createLogFile();
        }
    }

    @Override
    public void setLevel(Level newLevel) {
        super.setLevel(Objects.requireNonNull(newLevel));
        for (Handler h : this.getHandlers()) {
            h.setLevel(newLevel);
        }
        if (this.myAgent == this.myAgent.getKernel()) {
            return;
        }
        if (this.myAgent.hasGUI()) {
            AgentLogLevelMenu.update(this.myAgent);
        }
        if (newLevel != Level.OFF) {
            this.myAgent.setKernel(this.myAgent.getKernel().getLoggedKernel());
            if (newLevel == Level.ALL) {
                this.enableCGRWarnings();
            }
        } else {
            this.myAgent.setKernel(this.myAgent.getMadkitKernel());
        }
    }

    public void doNotReactToDebugMode() {
        debugModeBlackList.add(this);
    }

    public boolean isCGRWarningsOn() {
        return this.agentCGRWarningsOnAction != null && (Boolean)this.agentCGRWarningsOnAction.getValue("SwingSelectedKey") != false;
    }

    public void enableCGRWarnings() {
        this.getEnableCGRWarningsAction().putValue("SwingSelectedKey", true);
    }

    public void disableCGRWarnings() {
        if (this.agentCGRWarningsOnAction != null) {
            this.getEnableCGRWarningsAction().putValue("SwingSelectedKey", false);
        }
    }

    public BooleanAction getEnableCGRWarningsAction() {
        if (this.agentCGRWarningsOnAction == null) {
            this.agentCGRWarningsOnAction = (BooleanAction)LoggingAction.CGR_WARNINGS.getActionFor(this.myAgent, new Object[0]);
        }
        return this.agentCGRWarningsOnAction;
    }

    public void createLogFile() {
        this.addFileHandler(null, null, false, true);
    }

    public void addFileHandler(Path logDirectory, String fileName, boolean append, final boolean includeDefaultComment) {
        if (fileName == null) {
            fileName = this.getName();
        }
        if (logDirectory == null) {
            logDirectory = FileSystems.getDefault().getPath(this.myAgent.getMadkitConfig().getProperty(Madkit.Option.logDirectory.name()), new String[0]);
        }
        try {
            Files.createDirectories(logDirectory, new FileAttribute[0]);
            Path pathToFile = Paths.get(logDirectory.toString(), fileName);
            String lineSeparator = "--------------------------------------------------------------------------\n";
            final String logSession = "--------------------------------------------------------------------------\n-- Log session for " + this.getName();
            String logEnd = " --\n--------------------------------------------------------------------------\n\n";
            FileHandler fh = new FileHandler(pathToFile.toString(), append){

                @Override
                public synchronized void close() {
                    if (includeDefaultComment) {
                        String closeString = "\n\n" + logSession + " closed on  " + Madkit.DATE_FORMATTER.format(Instant.now()) + " --\n--------------------------------------------------------------------------\n\n";
                        this.publish(new LogRecord(TALK, closeString));
                    }
                    super.close();
                }
            };
            fh.setFormatter(AGENT_FILE_FORMATTER);
            this.addHandler(fh);
            if (includeDefaultComment) {
                String startComments = logSession + " started on " + Madkit.DATE_FORMATTER.format(Instant.now()) + " --\n--------------------------------------------------------------------------\n\n";
                fh.publish(new LogRecord(TALK, startComments));
            }
        }
        catch (IOException | SecurityException e) {
            e.printStackTrace();
        }
    }

    final synchronized void close() {
        for (Handler h : this.getHandlers()) {
            this.removeHandler(h);
            h.close();
        }
        agentLoggers.remove(this.myAgent);
    }

    @Override
    public synchronized void addHandler(Handler handler) {
        super.addHandler(handler);
        handler.setLevel(this.getLevel());
    }

    static void resetLoggers() {
        for (AgentLogger l : agentLoggers.values()) {
            l.close();
        }
    }

    public void talk(String msg) {
        if (this.getLevel() == Level.OFF) {
            System.out.print(msg);
        } else {
            this.log(TALK, msg);
        }
    }

    public String toString() {
        return this.getName() + " logger: \n\tlevel " + this.getLevel() + "\n\tcgrWarnings " + this.isCGRWarningsOn();
    }

    @Override
    public void log(LogRecord record) {
        Throwable t = record.getThrown();
        if (t != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            record.setMessage(record.getMessage() + "\n ** " + sw);
        }
        super.log(record);
    }

    @Override
    public boolean isLoggable(Level level) {
        return level != Level.OFF && level.intValue() >= this.getLevel().intValue();
    }

    public void severeLog(String message, Throwable t) {
        AgentLogger kernelLogger = this.myAgent.getMadkitKernel().logger;
        if (kernelLogger != null) {
            kernelLogger.log(Level.WARNING, t, () -> "log for " + this.myAgent + "\n" + message);
        }
        if (t != null) {
            this.myAgent.filterAgentStackTrace(t);
        }
        if (this.getLevel() == Level.OFF) {
            this.setLevel(Level.SEVERE);
        }
        this.log(Level.SEVERE, message, t);
    }

    public void severeLog(String message) {
        this.severeLog(message, null);
    }

    public static void setAllLogLevels(Level level) {
        for (AbstractAgent loggedAgent : agentLoggers.keySet()) {
            AgentLogger logger = loggedAgent.getLogger();
            if (!debugModeBlackList.contains(logger)) {
                logger.setLevel(level);
                continue;
            }
            loggedAgent.setMadkitProperty(Madkit.LevelOption.agentLogLevel, level.toString());
        }
    }

    public static void setAllLoggersAtLevelAll() {
        AgentLogger.setAllLogLevels(Level.ALL);
    }

    public static void resetAllLoggersToDefaultLevel() {
        String level = agentLoggers.keySet().iterator().next().getMadkitProperty(Madkit.LevelOption.agentLogLevel);
        AgentLogger.setAllLogLevels(Level.parse(level));
    }

    public static void createLogFiles() {
        try {
            AbstractAgent a = new ArrayList<AbstractAgent>(agentLoggers.keySet()).get(0);
            a.setMadkitProperty(Madkit.BooleanOption.createLogFiles.name(), "true");
            JOptionPane.showMessageDialog(null, (Object)((Object)Words.DIRECTORY) + " " + new File(a.getMadkitProperty(Madkit.Option.logDirectory)).getAbsolutePath() + " " + (Object)((Object)Words.CREATED), "OK", 1);
            for (AgentLogger logger : agentLoggers.values()) {
                logger.createLogFile();
            }
        }
        catch (IndexOutOfBoundsException e) {
            JOptionPane.showMessageDialog(null, "No active agents yet", Words.FAILED.toString(), 2);
        }
    }

    @Deprecated
    public Level getWarningLogLevel() {
        return Level.ALL;
    }

    @Deprecated
    public void setWarningLogLevel(Level warningLogLevel) {
        if (warningLogLevel != Level.OFF) {
            this.enableCGRWarnings();
        }
    }
}

