/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import madkit.kernel.AbstractAgent;
import madkit.kernel.MadkitKernel;
import madkit.kernel.Overlooker;
import madkit.kernel.Scheduler;

public abstract class Activator<A extends AbstractAgent>
extends Overlooker<A> {
    private int nbOfsimultaneousTasks = 1;
    private Scheduler.SimulationTime simulationTime;
    private Integer priority = null;
    private static final Map<Class<?>, Class<?>> primitiveTypes = new HashMap();

    protected Activator(String community, String group, String role) {
        super(community, group, role);
    }

    public Integer getPriority() {
        return this.priority;
    }

    void setPriority(int priority) {
        this.priority = priority;
    }

    public void execute(Object ... args) {
        if (this.isMulticoreModeOn()) {
            this.multicoreExecute(args);
        } else {
            this.execute(this.getCurrentAgentsList(), args);
        }
    }

    public void executeBehaviorOf(AbstractAgent agent, String behaviorName, Object ... args) {
        try {
            agent.executeBehavior(behaviorName, args);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void adding(A agent) {
        ((AbstractAgent)agent).setSimulationTime(this.getSimulationTime());
    }

    public abstract void execute(List<A> var1, Object ... var2);

    protected void multicoreExecute(final Object ... args) {
        final int cpuCoreNb = this.nbOfParallelTasks();
        ArrayList<Callable<Void>> workers = new ArrayList<Callable<Void>>(cpuCoreNb);
        final List list = this.getCurrentAgentsList();
        int bucketSize = list.size();
        final int nbOfAgentsPerTask = bucketSize / cpuCoreNb;
        int i = 0;
        while (i < cpuCoreNb) {
            final int index = i++;
            workers.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    int firstIndex = nbOfAgentsPerTask * index;
                    Activator.this.execute(list.subList(firstIndex, firstIndex + nbOfAgentsPerTask), args);
                    return null;
                }
            });
        }
        workers.add(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Activator.this.execute(list.subList(nbOfAgentsPerTask * cpuCoreNb, list.size()), args);
                return null;
            }
        });
        try {
            Activator.getMadkitServiceExecutor().invokeAll(workers);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public String toString() {
        return "P(" + this.getPriority() + ") " + super.toString();
    }

    public boolean isMulticoreModeOn() {
        return this.nbOfsimultaneousTasks > 1;
    }

    public void useMulticore(int nbOfParallelTasks) {
        this.nbOfsimultaneousTasks = nbOfParallelTasks < 2 ? 1 : nbOfParallelTasks;
    }

    public int nbOfParallelTasks() {
        return this.nbOfsimultaneousTasks;
    }

    public static ExecutorService getMadkitServiceExecutor() {
        return MadkitKernel.getMadkitServiceExecutor();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> Method findMethodOn(Class<T> agentClass, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        while (true) {
            try {
                Method m;
                while ((m = agentClass.getDeclaredMethod(methodName, parameterTypes)) == null) {
                }
                if (m.isAccessible()) return m;
                m.setAccessible(true);
                return m;
            }
            catch (SecurityException e) {
                e.printStackTrace();
                continue;
            }
            catch (NoSuchMethodException e) {
                if ((agentClass = agentClass.getSuperclass()) == Object.class) throw e;
                continue;
            }
            break;
        }
    }

    public static <T> Method findMethodOnFromArgsSample(Class<T> agentClass, String methodName, Object ... argsSample) throws NoSuchMethodException {
        Class<?>[] parameterTypes = Activator.getParameterTypes(argsSample);
        try {
            return Activator.findMethodOn(agentClass, methodName, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            do {
                Method m;
                if ((m = Activator.findMethodIn(methodName, agentClass.getDeclaredMethods(), parameterTypes)) == null) continue;
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
                return m;
            } while ((agentClass = agentClass.getSuperclass()) != Object.class);
            throw new NoSuchMethodException();
        }
    }

    public Scheduler.SimulationTime getSimulationTime() {
        return this.simulationTime;
    }

    final void setSimulationTime(Scheduler.SimulationTime simulationTime) {
        this.simulationTime = simulationTime;
    }

    private static Class<?>[] getParameterTypes(Object[] parameters) {
        Class[] paramTypes = new Class[parameters.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            if (parameters[i] == null) continue;
            paramTypes[i] = parameters[i].getClass();
        }
        return paramTypes;
    }

    private static boolean checkTypesCompatibility(Class<?>[] methodTypes, Class<?>[] parametersTypes) {
        if (parametersTypes.length == methodTypes.length) {
            for (int i = 0; i < methodTypes.length; ++i) {
                if (parametersTypes[i] == null || methodTypes[i].isAssignableFrom(parametersTypes[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static Class<?>[] convertPrimitiveToObjectTypes(Class<?>[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            Class<?> paramCl = parameters[i];
            if (paramCl == null || !paramCl.isPrimitive()) continue;
            parameters[i] = primitiveTypes.get(paramCl);
        }
        return parameters;
    }

    private static Method findMethodIn(String methodName, Method[] methods, Class<?>[] parameters) {
        for (Method method : methods) {
            if (!method.getName().equals(methodName) || !Activator.checkTypesCompatibility(Activator.convertPrimitiveToObjectTypes(method.getParameterTypes()), parameters)) continue;
            return method;
        }
        return null;
    }

    static {
        primitiveTypes.put(Integer.TYPE, Integer.class);
        primitiveTypes.put(Boolean.TYPE, Boolean.class);
        primitiveTypes.put(Byte.TYPE, Byte.class);
        primitiveTypes.put(Character.TYPE, Character.class);
        primitiveTypes.put(Float.TYPE, Float.class);
        primitiveTypes.put(Void.TYPE, Void.class);
        primitiveTypes.put(Short.TYPE, Short.class);
        primitiveTypes.put(Double.TYPE, Double.class);
        primitiveTypes.put(Long.TYPE, Long.class);
    }
}

