/*
 * Decompiled with CFR 0.152.
 */
package madkit.action;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import madkit.action.ActionInfo;
import madkit.action.MDKAbstractAction;
import madkit.i18n.I18nUtilities;

public enum UIAction {
    BACKGROUND(66){

        @Override
        public Action getActionFor(final JFrame f) {
            return new MDKAbstractAction(this.getActionInfo()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color selectedColor = JColorChooser.showDialog(f, "Selection", f.getBackground());
                    if (selectedColor != null) {
                        f.setBackground(selectedColor);
                    }
                }
            };
        }
    }
    ,
    PRINT(80){

        @Override
        public Action getActionFor(final JFrame frame) {
            return new MDKAbstractAction(this.getActionInfo()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PrinterJob job = PrinterJob.getPrinterJob();
                    job.setPrintable((Printable)((Object)frame));
                    if (job.printDialog()) {
                        try {
                            job.print();
                        }
                        catch (PrinterException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            };
        }
    };

    private static final ResourceBundle messages;
    private ActionInfo actionInfo;
    private final int keyEvent;

    public static ResourceBundle getMessages() {
        return messages;
    }

    public ActionInfo getActionInfo() {
        if (this.actionInfo == null) {
            this.actionInfo = new ActionInfo(this, this.keyEvent, messages);
        }
        return this.actionInfo;
    }

    private UIAction(int keyEvent) {
        this.keyEvent = keyEvent;
    }

    public abstract Action getActionFor(JFrame var1);

    static {
        messages = I18nUtilities.getResourceBundle(UIAction.class.getSimpleName());
    }
}

