/*
 * Decompiled with CFR 0.152.
 */
package com.flynnbuc.httpserverwrapper.services;

import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;

public class ServerService {
    private InetSocketAddress address;
    private HttpServer server;
    private int portNum = -1;

    public ServerService(int portNum) {
        this.portNum = portNum;
    }

    public ServerService() {
    }

    public int getPortNum() {
        return this.portNum;
    }

    public boolean startServer(int portNum) {
        this.portNum = portNum;
        return this.startServer();
    }

    public boolean startServer() {
        if (this.portNum == -1) {
            return false;
        }
        try {
            this.address = new InetSocketAddress(this.portNum);
            this.server = HttpServer.create(this.address, 0);
            this.server.setExecutor(null);
            this.server.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void exit() {
        this.exit(0);
    }

    public void exit(int delay) {
        try {
            this.server.stop(delay);
            System.out.println("Server Closed");
        }
        catch (Exception e) {
            System.err.println("Server exited with error : " + e.getLocalizedMessage());
        }
    }

    public void addContext(String path, HttpHandler handler) {
        this.server.createContext(path, handler);
    }

    public void removeContext(String path) {
        try {
            this.server.removeContext(path);
        }
        catch (Exception e) {
            System.err.println("Error in server for removing path: " + path + " " + e.getMessage());
        }
    }
}

