/*
 * Decompiled with CFR 0.152.
 */
package com.flynnbuc.httpserverwrapper.services;

import com.flynnbuc.httpserverwrapper.exceptions.CouldNotFindIPException;
import com.flynnbuc.httpserverwrapper.services.OSType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;

public class IPAddressChecker {
    public static String getLocalIP() throws CouldNotFindIPException {
        String ip = null;
        if (OSType.systemIsMacOS()) {
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress("google.com", 80));
                ip = socket.getLocalAddress().toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try (DatagramSocket socket = new DatagramSocket();){
                socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
                ip = socket.getLocalAddress().getHostAddress();
            }
            catch (SocketException | UnknownHostException e) {
                e.printStackTrace();
            }
        }
        if (ip == null) {
            throw new CouldNotFindIPException();
        }
        return ip.replace("/", "");
    }

    public static String getRemoteIP() throws CouldNotFindIPException {
        String ip = "";
        URL whatismyip = null;
        try {
            whatismyip = new URL("http://checkip.amazonaws.com");
            BufferedReader in = new BufferedReader(new InputStreamReader(whatismyip.openStream()));
            ip = in.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (ip == null) {
            throw new CouldNotFindIPException();
        }
        return ip;
    }
}

