/*
 * Decompiled with CFR 0.152.
 */
package com.flynnbuc.httpserverwrapper.main;

import com.flynnbuc.httpserverwrapper.enums.ServerMethodType;
import com.flynnbuc.httpserverwrapper.interfaces.ContextManager;
import com.flynnbuc.httpserverwrapper.main.ServerController;
import com.flynnbuc.httpserverwrapper.model.Context;
import com.flynnbuc.httpserverwrapper.model.Handler;
import com.flynnbuc.httpserverwrapper.model.NetworkRequest;
import com.flynnbuc.httpserverwrapper.model.Notification;
import com.sun.net.httpserver.HttpExchange;
import java.beans.PropertyChangeEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSONServerController
extends ServerController<JSONObject> {
    private final Map<Long, NetworkRequest<JSONObject>> requestQueue = new ConcurrentHashMap<Long, NetworkRequest<JSONObject>>();

    public JSONServerController(ContextManager manager) {
        super(manager);
    }

    @Override
    public synchronized void createContexts(Context ... contextsToCreate) {
        for (Context context : contextsToCreate) {
            this.serverService.addContext(context.path(), new ServerHandler(context.path(), context.type(), context.notification()));
        }
    }

    @Override
    public synchronized void handleRequestResponse(long requestNum, JSONObject response, int responseCode) {
        NetworkRequest<JSONObject> request = this.requestQueue.remove(requestNum);
        if (request == null) {
            System.out.println("request is null");
        } else {
            this.respondToRequest(response, request.getExchange(), responseCode);
        }
    }

    @Override
    protected synchronized void respondToRequest(JSONObject response, HttpExchange exchange, int responseCode) {
        try {
            byte[] responseBytes = response.toString().getBytes();
            exchange.sendResponseHeaders(responseCode, responseBytes.length);
            OutputStream os = exchange.getResponseBody();
            os.write(responseBytes);
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Handler httpHandler;
        Object object;
        if (evt.getPropertyName().equalsIgnoreCase(PROPERTY_CHANGE_STR) && (object = evt.getNewValue()) instanceof Handler && (httpHandler = (Handler)object) == (Handler)object) {
            this.serverService.addContext(httpHandler.getPath(), httpHandler);
        }
    }

    private void fireNotifications(Notification notification, JSONObject body, long id) {
        super.fireNotification(notification, body, id);
    }

    private class ServerHandler
    extends Handler {
        private final ServerMethodType type;
        private final Notification notification;
        private JSONObject response;

        public ServerHandler(String path, ServerMethodType type, Notification notification) {
            super(path);
            this.type = type;
            this.notification = notification;
        }

        @Override
        public void handle(HttpExchange exchange) {
            try {
                JSONObject requestBody;
                this.response = new JSONObject();
                if (!exchange.getRequestURI().toString().equalsIgnoreCase(this.getPath())) {
                    this.response.put("message", (Object)("invalid path " + this.getPath()));
                    JSONServerController.this.respondToRequest(this.response, exchange, 404);
                    return;
                }
                if (!exchange.getRequestMethod().equalsIgnoreCase(this.type.toString())) {
                    this.response.put("message", (Object)("invalid request type " + exchange.getRequestMethod() + " at path " + this.getPath()));
                    JSONServerController.this.respondToRequest(this.response, exchange, 406);
                    return;
                }
                InputStream is = exchange.getRequestBody();
                String requestStr = new BufferedReader(new InputStreamReader(is)).lines().collect(Collectors.joining("\n"));
                if (requestStr.trim().equalsIgnoreCase("") || requestStr.isBlank() || requestStr.isEmpty()) {
                    requestBody = new JSONObject();
                } else {
                    JSONTokener parser = new JSONTokener(requestStr);
                    requestBody = new JSONObject(parser);
                }
                if (exchange.getRequestURI().toString().equalsIgnoreCase(this.getPath())) {
                    NetworkRequest request = new NetworkRequest(JSONServerController.this.generateRequestNum(), exchange, this.getPath());
                    JSONServerController.this.requestQueue.put(request.getRequestNum(), request);
                    JSONServerController.this.fireNotifications(this.notification, requestBody, request.getRequestNum());
                }
            }
            catch (Exception e) {
                System.err.println(e.getLocalizedMessage());
            }
        }
    }
}

