/*
 * Decompiled with CFR 0.152.
 */
package io.github.floverfelt.find.and.replace.maven.plugin.tasks;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.maven.plugin.logging.Log;

public class ProcessFilesTask {
    private ProcessFilesTask() {
    }

    public static void process(Log log, Path baseDir, boolean isRecursive, Pattern findRegex, String replaceValue, List<String> fileMasks, List<Pattern> exclusions, boolean processFileContents, boolean processFilenames, boolean processDirectoryNames, Charset charset) throws IOException {
        ArrayList<File> filesToProcess = new ArrayList<File>(Arrays.asList(Objects.requireNonNull(new File(baseDir.toUri()).listFiles())));
        ListIterator<File> iterator = filesToProcess.listIterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            iterator.remove();
            if (file.isDirectory()) {
                iterator = ProcessFilesTask.processDirectory(iterator, isRecursive, file, processDirectoryNames, exclusions, findRegex, replaceValue, log);
            }
            if (!file.isFile()) continue;
            ProcessFilesTask.processFile(log, exclusions, file, fileMasks, processFileContents, findRegex, replaceValue, processFilenames, charset);
        }
    }

    private static ListIterator<File> processDirectory(ListIterator<File> iterator, boolean isRecursive, File file, boolean processDirectoryNames, List<Pattern> exclusions, Pattern findRegex, String replaceValue, Log log) throws IOException {
        if (processDirectoryNames && !ProcessFilesTask.shouldExcludeFile(exclusions, file)) {
            file = ProcessFilesTask.renameFile(log, file, findRegex, replaceValue);
        }
        if (isRecursive) {
            File[] filesToAdd = file.listFiles();
            assert (filesToAdd != null);
            for (File f : filesToAdd) {
                iterator.add(f);
                iterator.previous();
            }
        }
        return iterator;
    }

    private static boolean shouldExcludeFile(List<Pattern> exclusions, File file) {
        for (Pattern p : exclusions) {
            if (!p.matcher(file.getName()).find()) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldProcessFile(List<String> fileMasks, File file) {
        if (fileMasks.isEmpty()) {
            return true;
        }
        for (String fileMask : fileMasks) {
            if (!file.getName().endsWith(fileMask)) continue;
            return true;
        }
        return false;
    }

    private static File renameFile(Log log, File file, Pattern findRegex, String replaceValue) throws IOException {
        Path filePath = file.toPath();
        Path parentDir = filePath.getParent();
        String oldName = file.getName();
        Matcher matcher = findRegex.matcher(oldName);
        String newName = matcher.replaceAll(replaceValue);
        if (!newName.equals(oldName)) {
            Path targetPath = Paths.get(parentDir.toString(), newName);
            log.info((CharSequence)String.format("Renaming %s to %s", oldName, newName));
            return new File(Files.move(filePath, targetPath, new CopyOption[0]).toUri());
        }
        return file;
    }

    private static void processFileContents(File file, Pattern findRegex, String replaceValue, Charset charset) throws IOException {
        File tempFile = File.createTempFile("tmp", "tmp", file.getParentFile());
        try (FileInputStream fis = new FileInputStream(file);
             InputStreamReader isr = new InputStreamReader((InputStream)fis, charset);
             BufferedReader fileReader = new BufferedReader(isr);
             FileOutputStream fos = new FileOutputStream(tempFile);
             OutputStreamWriter osr = new OutputStreamWriter((OutputStream)fos, charset);
             BufferedWriter fileWriter = new BufferedWriter(osr);){
            Stream<String> lines = fileReader.lines();
            lines.forEach(line -> {
                Matcher matcher = findRegex.matcher((CharSequence)line);
                line = matcher.replaceAll(replaceValue);
                try {
                    fileWriter.write(line + "\n");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        if (!file.delete()) {
            throw new IOException("Failed to delete file at: " + file.getPath());
        }
        if (!tempFile.renameTo(file)) {
            throw new IOException("Failed to rename temp file at: " + tempFile.getPath() + " to " + file.getPath());
        }
    }

    private static void processFile(Log log, List<Pattern> exclusions, File file, List<String> fileMasks, boolean processFileContents, Pattern findRegex, String replaceValue, boolean processFilenames, Charset charset) throws IOException {
        if (ProcessFilesTask.shouldExcludeFile(exclusions, file) || !ProcessFilesTask.shouldProcessFile(fileMasks, file)) {
            return;
        }
        if (processFileContents) {
            ProcessFilesTask.processFileContents(file, findRegex, replaceValue, charset);
        }
        if (processFilenames) {
            ProcessFilesTask.renameFile(log, file, findRegex, replaceValue);
        }
    }
}

