/*
 * Decompiled with CFR 0.152.
 */
package io.github.floverfelt.find.and.replace.maven.plugin;

import io.github.floverfelt.find.and.replace.maven.plugin.tasks.ProcessFilesTask;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="find-and-replace", defaultPhase=LifecyclePhase.NONE, threadSafe=true)
public class FindAndReplaceMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="baseDir", defaultValue="${basedir}")
    private String baseDir;
    @Parameter(property="recursive", defaultValue="false")
    private boolean recursive;
    @Parameter(property="replacementType", required=true)
    private String replacementType;
    @Parameter(property="findRegex", required=true)
    private String findRegex;
    @Parameter(property="replaceValue", required=true, defaultValue="")
    private String replaceValue;
    @Parameter(property="fileMask")
    private String fileMask;
    @Parameter(property="exclusions")
    private String exclusions;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="encoding")
    private String encoding;
    private Charset charset = Charset.defaultCharset();
    private static final String FILE_CONTENTS = "file-contents";
    private static final String FILENAMES = "filenames";
    private static final String DIRECTORY_NAMES = "directory-names";
    private Path baseDirPath;
    private List<String> validReplacementTypes = Arrays.asList("file-contents", "filenames", "directory-names");
    private boolean processFileContents = false;
    private boolean processFilenames = false;
    private boolean processDirectoryNames = false;
    private List<String> fileMaskList = new ArrayList<String>();
    private List<Pattern> exclusionsList = new ArrayList<Pattern>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().warn((CharSequence)"Skipping execution of find-and-replace-maven-plugin.");
            return;
        }
        this.setup();
        this.getLog().info((CharSequence)("Executing find-and-replace maven plugin with options: " + this.toString()));
        try {
            ProcessFilesTask.process(this.getLog(), this.baseDirPath, this.recursive, Pattern.compile(this.findRegex), this.replaceValue, this.fileMaskList, this.exclusionsList, this.processFileContents, this.processFilenames, this.processDirectoryNames, this.charset);
        }
        catch (Exception e) {
            throw new MojoFailureException("Unable to process files.", (Throwable)e);
        }
    }

    private void setup() throws MojoExecutionException {
        this.setupReplacementTypes();
        this.setupFileMasks();
        this.setupExclusions();
        this.setupBaseDir();
        this.setupEncoding();
    }

    private void setupReplacementTypes() throws MojoExecutionException {
        String[] replacementTypeList = StringUtils.split((String)this.replacementType, (String)",");
        String logMessage = "Mode set to ";
        for (String replacementTypeVal : replacementTypeList) {
            if (!this.validReplacementTypes.contains(replacementTypeVal)) {
                throw new MojoExecutionException("Invalid replacementType specified: " + replacementTypeVal);
            }
            if (FILE_CONTENTS.equals(replacementTypeVal)) {
                this.getLog().info((CharSequence)(logMessage + FILE_CONTENTS));
                this.processFileContents = true;
            }
            if (FILENAMES.equals(replacementTypeVal)) {
                this.getLog().info((CharSequence)(logMessage + FILENAMES));
                this.processFilenames = true;
            }
            if (!DIRECTORY_NAMES.equals(replacementTypeVal)) continue;
            this.getLog().info((CharSequence)(logMessage + DIRECTORY_NAMES));
            this.processDirectoryNames = true;
        }
    }

    private void setupFileMasks() {
        if (StringUtils.isNotEmpty((CharSequence)this.fileMask)) {
            this.fileMaskList = Arrays.asList(StringUtils.split((String)this.fileMask, (String)","));
            this.getLog().info((CharSequence)("fileMasks set to: " + this.fileMaskList));
        }
    }

    private void setupEncoding() {
        if (StringUtils.isNotEmpty((CharSequence)this.encoding)) {
            try {
                this.charset = Charset.forName(this.encoding);
                this.getLog().info((CharSequence)("encoding set to: " + this.charset));
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Invalid encoding value " + this.encoding + ". Using default charset."));
            }
        }
    }

    private void setupExclusions() {
        if (StringUtils.isNotEmpty((CharSequence)this.exclusions)) {
            this.getLog().info((CharSequence)("Compiling regex for exclusions: " + this.exclusions));
            this.exclusionsList.add(Pattern.compile(this.exclusions));
        }
    }

    private void setupBaseDir() {
        this.baseDirPath = this.project == null ? Paths.get(this.baseDir, new String[0]) : (this.baseDir.equals(this.project.getBasedir().getAbsolutePath()) ? Paths.get(this.baseDir, new String[0]) : Paths.get(this.project.getBasedir().getAbsolutePath(), this.baseDir));
        this.getLog().info((CharSequence)("baseDir set to: " + this.baseDirPath.toString()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FindAndReplaceMojo{");
        sb.append("baseDir='").append(this.baseDir).append('\'');
        sb.append(", recursive=").append(this.recursive);
        sb.append(", replacementType='").append(this.replacementType).append('\'');
        sb.append(", findRegex='").append(this.findRegex).append('\'');
        sb.append(", replaceValue='").append(this.replaceValue).append('\'');
        sb.append(", fileMask='").append(this.fileMask).append('\'');
        sb.append(", exclusions='").append(this.exclusions).append('\'');
        sb.append(", skip=").append(this.skip);
        sb.append(", baseDirPath=").append(this.baseDirPath);
        sb.append(", processFileContents=").append(this.processFileContents);
        sb.append(", processFilenames=").append(this.processFilenames);
        sb.append(", processDirectoryNames=").append(this.processDirectoryNames);
        sb.append(", fileMaskList=").append(this.fileMaskList);
        sb.append(", exclusionsList=").append(this.exclusionsList);
        sb.append(", encoding=").append(this.encoding);
        sb.append('}');
        return sb.toString();
    }
}

