/*
 * Decompiled with CFR 0.152.
 */
package com.silent.engine;

import android.content.res.AssetManager;
import androidx.annotation.Keep;
import com.silent.engine.FaceBox;
import com.silent.engine.LiveDetector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0007J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/silent/engine/AntiSpoofingEngine;", "", "assetManager", "Landroid/content/res/AssetManager;", "(Landroid/content/res/AssetManager;)V", "liveDetector", "Lcom/silent/engine/LiveDetector;", "destroy", "", "detectLive", "", "yuv", "", "width", "", "height", "orientation", "faceBox", "Lcom/silent/engine/FaceBox;", "init", "", "silentEngine_release"})
@Keep
public final class AntiSpoofingEngine {
    @NotNull
    private AssetManager assetManager;
    @Keep
    @NotNull
    private LiveDetector liveDetector;

    public AntiSpoofingEngine(@NotNull AssetManager assetManager) {
        Intrinsics.checkNotNullParameter((Object)assetManager, (String)"assetManager");
        this.assetManager = assetManager;
        this.liveDetector = new LiveDetector();
    }

    @Keep
    public final boolean init() {
        int ret = this.liveDetector.loadModel(this.assetManager);
        return ret == 0;
    }

    @Keep
    public final void destroy() {
        this.liveDetector.destroy();
    }

    @Keep
    public final float detectLive(@NotNull byte[] yuv, int width, int height, int orientation, @NotNull FaceBox faceBox) {
        Intrinsics.checkNotNullParameter((Object)yuv, (String)"yuv");
        Intrinsics.checkNotNullParameter((Object)faceBox, (String)"faceBox");
        return this.liveDetector.detect(yuv, width, height, orientation, faceBox);
    }
}

