/*
 * Decompiled with CFR 0.152.
 */
package com.ai.face.base.view.camera;

import android.content.Context;

public class CameraXBuilder {
    private final float linearZoom;
    private final int cameraLensFacing;
    private final int rotation;

    private CameraXBuilder(Builder builder) {
        this.linearZoom = builder.linearZoom;
        this.cameraLensFacing = builder.cameraLensFacing;
        this.rotation = builder.rotation;
    }

    public float getLinearZoom() {
        return this.linearZoom;
    }

    public int getCameraLensFacing() {
        return this.cameraLensFacing;
    }

    public int getRotation() {
        return this.rotation;
    }

    public static class Builder {
        private Context context;
        private float linearZoom = 0.001f;
        private int cameraLensFacing = 0;
        private int rotation = 0;

        public Builder setCameraLensFacing(int n) {
            this.cameraLensFacing = n;
            return this;
        }

        public Builder setRotation(int n) {
            this.rotation = n;
            return this;
        }

        public Builder setLinearZoom(float f) {
            this.linearZoom = f;
            return this;
        }

        public CameraXBuilder create() {
            return new CameraXBuilder(this);
        }
    }
}

