/*
 * Decompiled with CFR 0.152.
 */
package com.ai.face.base.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.media.Image;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.ImageProxy;
import com.ai.face.base.utils.BitmapUtils;
import com.face.libyuv.FourCC;
import com.face.libyuv.LibYuv;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Objects;

public class DataConvertUtils {
    @OptIn(markerClass={ExperimentalGetImage.class})
    public static Bitmap imageProxy2Bitmap(ImageProxy object, int n, boolean bl) {
        n = object.getImageInfo().getRotationDegrees();
        ImageProxy imageProxy = object;
        byte[] byArray = LibYuv.imageToI420((Image)Objects.requireNonNull(imageProxy.getImage()), (int)n);
        int n2 = imageProxy.getWidth();
        int n3 = imageProxy.getHeight();
        if (n == 90 || n == 270) {
            ImageProxy imageProxy2 = object;
            n2 = imageProxy2.getHeight();
            n3 = imageProxy2.getWidth();
        }
        object = LibYuv.convertFromI420((byte[])byArray, (int)n2, (int)n3, (FourCC)FourCC.FOURCC_ABGR);
        return BitmapUtils.Ii1\u4e28Ii\u4e28L.Ii1\u4e28Ii\u4e28L(n2, n3, (byte[])object);
    }

    public static void Ii1\u4e28Ii\u4e28L(ImageProxy imageProxy, Bitmap bitmap) {
        ImageProxy imageProxy2 = imageProxy;
        int n = imageProxy2.getImageInfo().getRotationDegrees();
        byte[] byArray = LibYuv.imageToI420((Image)Objects.requireNonNull(imageProxy2.getImage()), (int)n);
        Bitmap bitmap2 = bitmap;
        n = bitmap2.getWidth();
        int n2 = bitmap2.getHeight();
        bitmap.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(LibYuv.convertFromI420((byte[])byArray, (int)n, (int)n2, (FourCC)FourCC.FOURCC_ABGR)));
    }

    public static Bitmap Ii1\u4e28Ii\u4e28L(byte[] object, int n, int n2) {
        ByteArrayOutputStream byteArrayOutputStream;
        YuvImage yuvImage;
        YuvImage yuvImage2 = yuvImage;
        yuvImage = new YuvImage(object, 17, n, n2, null);
        object = byteArrayOutputStream;
        object();
        yuvImage2.compressToJpeg(new Rect(0, 0, n, n2), 100, (OutputStream)object);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
    }

    @Nullable
    public static Bitmap NV21Data2Bitmap(ByteBuffer byteBuffer, int n, int n2, int n3, boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream;
        YuvImage yuvImage;
        ByteBuffer byteBuffer2 = byteBuffer;
        byteBuffer2.rewind();
        int n4 = byteBuffer2.limit();
        byte[] byArray = new byte[n4];
        byteBuffer2.get(byArray, 0, n4);
        try {
            yuvImage = new YuvImage(byArray, 17, n, n2, null);
        }
        catch (Exception exception) {
            Log.e((String)"VisionProcessorBase", (String)("Error: " + exception.getMessage()));
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        yuvImage.compressToJpeg(new Rect(0, 0, n, n2), 100, (OutputStream)byteArrayOutputStream2);
        byte[] byArray2 = byteArrayOutputStream2.toByteArray();
        n = 0;
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray2, (int)n, (int)byteArrayOutputStream2.size());
        byteArrayOutputStream2.close();
        return DataConvertUtils.Ii1\u4e28Ii\u4e28L(bitmap, n3, bl, false);
    }

    public static byte[] Ii1\u4e28Ii\u4e28L(Bitmap object, int n, int n2) {
        int n3 = n * n2;
        Bitmap bitmap = object;
        int[] nArray = new int[n3];
        object = nArray;
        bitmap.getPixels(nArray, 0, n, 0, 0, n, n2);
        byte[] byArray = new byte[n3 * 3 / 2];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Object object2 = object[i * n + j];
                int n5 = object2 >> 16 & 0xFF;
                Bitmap bitmap2 = object2;
                object2 = bitmap2 >> 8 & 0xFF;
                int n6 = bitmap2 & 0xFF;
                byArray[n4++] = (byte)Math.max(0, Math.min((n5 * 66 + object2 * 129 + n6 * 25 + 128 >> 8) + 16, 255));
                if (i % 2 != 0 || j % 2 != 0) continue;
                int n7 = (n5 * -38 - object2 * 74 + n6 * 112 + 128 >> 8) + 128;
                int n8 = (n5 * 112 - object2 * 94 - n6 * 18 + 128 >> 8) + 128;
                object2 = n3 + 1;
                byArray[n3] = (byte)Math.max(0, Math.min(n8, 255));
                n3 += 2;
                n5 = Math.min(n7, 255);
                byArray[object2] = (byte)Math.max(0, n5);
            }
        }
        return byArray;
    }

    public static byte[] L1\u4e28iL\u4e28L(Bitmap bitmap, int n, int n2) {
        Object[] objectArray = new byte[]{};
        if (bitmap != null && bitmap.getWidth() >= n && bitmap.getHeight() >= n2) {
            int[] nArray = new int[n * n2];
            objectArray = nArray;
            bitmap.getPixels((int[])objectArray, 0, n, 0, 0, n, n2);
            return DataConvertUtils.Ii1\u4e28Ii\u4e28L(nArray, n, n2);
        }
        return objectArray;
    }

    public static Bitmap Ii1\u4e28Ii\u4e28L(Bitmap bitmap, int n, boolean bl, boolean bl2) {
        Matrix matrix;
        Matrix matrix2 = matrix;
        matrix2();
        matrix.postRotate((float)n);
        float f = bl ? -1.0f : 1.0f;
        float f2 = bl2 ? -1.0f : 1.0f;
        Bitmap bitmap2 = bitmap;
        matrix2.postScale(f, f2);
        int n2 = bitmap2.getWidth();
        int n3 = bitmap2.getHeight();
        Bitmap bitmap3 = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)n2, (int)n3, (Matrix)matrix2, (boolean)true);
        if (bitmap3 != bitmap) {
            bitmap.recycle();
            return bitmap3;
        }
        return bitmap3;
    }

    public static byte[] Ii1\u4e28Ii\u4e28L(int[] nArray, int n, int n2) {
        int n3 = n * n2;
        int n4 = 0;
        int n5 = 0;
        int n6 = n3 * 3 / 2;
        byte[] byArray = new byte[n6];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n7 = nArray[n5];
                int n8 = (n7 & 0xFF0000) >> 16;
                int n9 = n7;
                n7 = (n9 & 0xFF00) >> 8;
                int n10 = n9 & 0xFF;
                int n11 = (n8 * 66 + n7 * 129 + n10 * 25 + 128 >> 8) + 16;
                int n12 = n8;
                n8 = (n12 * -38 - n7 * 74 + n10 * 112 + 128 >> 8) + 128;
                n7 = (n12 * 112 - n7 * 94 - n10 * 18 + 128 >> 8) + 128;
                n10 = n4 + 1;
                if (n11 < 0) {
                    n11 = 0;
                } else if (n11 > 255) {
                    n11 = 255;
                }
                byArray[n4] = (byte)n11;
                if (i % 2 == 0 && n5 % 2 == 0 && n3 < n6 - 2) {
                    n4 = n3 + 1;
                    if (n7 < 0) {
                        n7 = 0;
                    } else if (n7 > 255) {
                        n7 = 255;
                    }
                    byArray[n3] = (byte)n7;
                    n3 += 2;
                    if (n8 < 0) {
                        n8 = 0;
                    } else if (n8 > 255) {
                        n8 = 255;
                    }
                    byArray[n4] = (byte)n8;
                }
                n4 = n5 + 1;
                int n13 = n4;
                n4 = n10;
                n5 = n13;
            }
        }
        return byArray;
    }
}

