/*
 * Decompiled with CFR 0.152.
 */
package io.github.endreman0.javajson.nodes;

import io.github.endreman0.javajson.nodes.BooleanNode;
import io.github.endreman0.javajson.nodes.Node;
import io.github.endreman0.javajson.nodes.NumberNode;
import io.github.endreman0.javajson.nodes.ObjectNode;
import io.github.endreman0.javajson.nodes.ParentNode;
import io.github.endreman0.javajson.nodes.StringNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ArrayNode
extends ParentNode
implements List<Node> {
    private List<Node> children = new ArrayList<Node>();

    public ArrayNode() {
    }

    public ArrayNode(Node ... children) {
        this();
        this.addAll(children);
    }

    public ArrayNode(Iterable<Node> children) {
        this();
        this.addAll(children);
    }

    @Override
    public boolean add(Node node) {
        if (node != null) {
            this.children.add(node);
            node.parent = this;
            return true;
        }
        return false;
    }

    @Override
    public void add(int index, Node node) {
        if (node != null) {
            this.children.add(index, node);
            node.parent = this;
        }
    }

    public ArrayNode addAll(Node ... nodes) {
        for (Node node : nodes) {
            this.add(node);
        }
        return this;
    }

    public ArrayNode addAll(Iterable<Node> nodes) {
        for (Node node : nodes) {
            this.add(node);
        }
        return this;
    }

    public ArrayNode addAll(int index, Node ... nodes) {
        for (Node node : nodes) {
            this.add(index++, node);
        }
        return this;
    }

    public ArrayNode addAll(int index, Iterable<Node> nodes) {
        for (Node node : nodes) {
            this.add(index++, node);
        }
        return this;
    }

    @Override
    public Node get(int index) {
        return this.children.get(index);
    }

    public ArrayNode getArray(int index) {
        Node node = this.get(index);
        if (node instanceof ArrayNode) {
            return (ArrayNode)node;
        }
        return null;
    }

    public BooleanNode getBoolean(int index) {
        Node node = this.get(index);
        if (node instanceof BooleanNode) {
            return (BooleanNode)node;
        }
        return null;
    }

    public NumberNode getNumber(int index) {
        Node node = this.get(index);
        if (node instanceof NumberNode) {
            return (NumberNode)node;
        }
        return null;
    }

    public ObjectNode getObject(int index) {
        Node node = this.get(index);
        if (node instanceof ObjectNode) {
            return (ObjectNode)node;
        }
        return null;
    }

    public StringNode getString(int index) {
        Node node = this.get(index);
        if (node instanceof StringNode) {
            return (StringNode)node;
        }
        return null;
    }

    public int indexOf(Node node) {
        return this.children.indexOf(node);
    }

    @Override
    public boolean contains(Node node) {
        return this.children.contains(node);
    }

    @Override
    public Node remove(int index) {
        return this.children.remove(index);
    }

    @Override
    public boolean remove(Node node) {
        if (this.children.remove(node)) {
            node.parent = null;
            return true;
        }
        return false;
    }

    @Override
    public void removeAll() {
        this.children.clear();
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public Iterator<Node> iterator() {
        return this.children.iterator();
    }

    @Override
    public ListIterator<Node> listIterator() {
        return this.children.listIterator();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ArrayNode)) {
            return false;
        }
        ArrayNode node = (ArrayNode)obj;
        if (this.size() != node.size()) {
            return false;
        }
        Iterator<Node> i1 = this.iterator();
        Iterator<Node> i2 = node.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (i1.next().equals(i2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        ListIterator<Node> i = this.children.listIterator();
        while (i.hasNext()) {
            if (i.nextIndex() % 2 == 1) {
                hashCode += i.next().hashCode();
                continue;
            }
            hashCode -= i.next().hashCode();
        }
        return hashCode;
    }

    @Override
    public String json() {
        StringBuilder sb = new StringBuilder().append("[\r\n");
        Iterator<Node> i = this.iterator();
        while (i.hasNext()) {
            sb.append(" ").append(i.next().toString().replace("\n", "\n "));
            if (!i.hasNext()) continue;
            sb.append(",\r\n");
        }
        return sb.append("\r\n]").toString();
    }

    @Override
    public String innerJSON() {
        StringBuilder sb = new StringBuilder();
        Iterator<Node> i = this.iterator();
        while (i.hasNext()) {
            sb.append(i.next().toString());
            if (!i.hasNext()) continue;
            sb.append(",\r\n");
        }
        return sb.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.children.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.children.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.children.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        return o instanceof Node ? this.remove((Node)o) : false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.children.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Node> c) {
        for (Node node : c) {
            this.add(node);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Node> c) {
        for (Node node : c) {
            this.add(index++, node);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret = false;
        for (Object o : c) {
            ret |= this.remove(o);
        }
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean ret = false;
        int i = 0;
        while (i < this.size()) {
            Node node = this.get(i);
            if (c.contains(node)) {
                ++i;
                continue;
            }
            this.remove(node);
            ret = true;
        }
        return ret;
    }

    @Override
    public void clear() {
        this.removeAll();
    }

    @Override
    public Node set(int index, Node element) {
        Node prev = this.children.set(index, element);
        prev.parent = null;
        element.parent = this;
        return prev;
    }

    @Override
    public int indexOf(Object o) {
        return this.children.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.children.lastIndexOf(o);
    }

    @Override
    public ListIterator<Node> listIterator(int index) {
        return this.children.listIterator(index);
    }

    @Override
    public List<Node> subList(int fromIndex, int toIndex) {
        return new ArrayNode(this.children.subList(fromIndex, toIndex));
    }
}

