/*
 * Decompiled with CFR 0.152.
 */
package net.bioclipse.managers;

import io.github.egonw.bacting.IBactingManager;
import java.util.Collections;
import java.util.List;
import net.bioclipse.biojava.domain.BiojavaDNA;
import net.bioclipse.biojava.domain.BiojavaProtein;
import net.bioclipse.core.domain.IDNA;
import net.bioclipse.core.domain.IProtein;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.symbol.IllegalSymbolException;

public class BiojavaManager
implements IBactingManager {
    private String workspaceRoot;

    public BiojavaManager(String workspaceRoot) {
        this.workspaceRoot = workspaceRoot;
    }

    public String getManagerName() {
        return "biojava";
    }

    public List<String> doi() {
        return Collections.emptyList();
    }

    public IDNA DNAfromPlainSequence(String dnaString) {
        return this.DNAfromPlainSequence(dnaString, "seq" + System.currentTimeMillis());
    }

    public IDNA DNAfromPlainSequence(String dnaString, String name) {
        try {
            return new BiojavaDNA(DNATools.createDNASequence((String)dnaString, (String)name));
        }
        catch (IllegalSymbolException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public IProtein proteinFromPlainSequence(String proteinString) {
        return this.proteinFromPlainSequence(proteinString, "seq" + System.currentTimeMillis());
    }

    public IProtein proteinFromPlainSequence(String proteinString, String name) {
        try {
            return new BiojavaProtein(ProteinTools.createProteinSequence((String)proteinString, (String)name));
        }
        catch (IllegalSymbolException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

